/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.IngestionProperties;
import com.microsoft.azure.kusto.ingest.ManagedStreamingQueuingPolicyPredicator;

public class ManagedStreamingQueuingPolicy
implements ManagedStreamingQueuingPolicyPredicator {
    static final int MAX_STREAMING_UNCOMPRESSED_RAW_SIZE_BYTES = 0x400000;
    static final int MAX_STREAMING_STREAM_SIZE_BYTES = 0xA00000;
    static final double JSON_UNCOMPRESSED_FACTOR = 1.5;
    static final int NON_BINARY_FACTOR = 2;
    static final double BINARY_COMPRESSED_FACTOR = 2.0;
    static final double BINARY_UNCOMPRESSED_FACTOR = 1.5;
    private final double factor;
    public static final ManagedStreamingQueuingPolicy Default = new ManagedStreamingQueuingPolicy(1.0);

    public ManagedStreamingQueuingPolicy(double factor) {
        Ensure.isTrue((factor > 0.0 ? 1 : 0) != 0, (String)"ManagedStreamingQueuingPolicy: factor should be greater than 0");
        this.factor = factor;
    }

    @Override
    public boolean shouldUseQueuedIngestion(long dataSize, boolean compressed, IngestionProperties.DataFormat dataFormat) {
        if (dataSize <= 0L) {
            return false;
        }
        if ((double)dataSize > this.factor * 1.048576E7) {
            return true;
        }
        if (!dataFormat.isCompressible()) {
            if (compressed) {
                return (double)dataSize * 2.0 > this.factor * 4194304.0;
            }
            return (double)dataSize * 1.5 > this.factor * 4194304.0;
        }
        if (compressed) {
            return (double)(dataSize * 2L) > this.factor * 4194304.0;
        }
        if (dataFormat.isJsonFormat()) {
            return (double)dataSize / 1.5 > this.factor * 4194304.0;
        }
        return (double)dataSize / 2.0 > this.factor * 4194304.0;
    }
}

