/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.exceptions.ExceptionUtils;
import com.microsoft.azure.kusto.data.instrumentation.FunctionOneException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import com.microsoft.azure.kusto.ingest.AzureStorageClient;
import com.microsoft.azure.kusto.ingest.IngestionBlobInfo;
import com.microsoft.azure.kusto.ingest.ResourceManager;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import com.microsoft.azure.kusto.ingest.resources.RankedStorageAccount;
import com.microsoft.azure.kusto.ingest.resources.ResourceWithSas;
import com.microsoft.azure.kusto.ingest.utils.SecurityUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAlgorithms {
    private static final int RETRY_COUNT = 3;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ResourceAlgorithms() {
    }

    private static <TInner, TWrapper extends ResourceWithSas<TInner>, TOut> TOut resourceActionWithRetries(ResourceManager resourceManager, List<TWrapper> resources, FunctionOneException<TOut, TWrapper, Exception> action, String actionName, Map<String, String> additionalAttributes) throws IngestionClientException {
        if (resources.isEmpty()) {
            throw new IngestionClientException(String.format("%s: No resources were provided.", actionName));
        }
        ArrayList totalAttributes = new ArrayList();
        Exception ex = null;
        for (int i = 0; i < 3; ++i) {
            ResourceWithSas resource = (ResourceWithSas)resources.get(i % resources.size());
            try {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("resource", resource.getEndpointWithoutSas());
                attributes.put("account", resource.getAccountName());
                attributes.put("type", resource.getClass().getName());
                attributes.put("retry", String.valueOf(i));
                attributes.putAll(additionalAttributes);
                totalAttributes.add(attributes);
                return (TOut)MonitoredActivity.invoke(span -> {
                    try {
                        Object result = action.apply((Object)resource);
                        resourceManager.reportIngestionResult(resource, true);
                        return result;
                    }
                    catch (Exception e) {
                        resourceManager.reportIngestionResult(resource, false);
                        span.addException(e);
                        throw e;
                    }
                }, (String)actionName, attributes);
            }
            catch (Exception e) {
                ex = e;
                log.warn(String.format("Error during retry %d of %d for %s", i + 1, 3, actionName), (Throwable)e);
                continue;
            }
        }
        throw new IngestionClientException(String.format("%s: All %d retries failed with last error: %s\n. Used resources: %s", actionName, 3, totalAttributes.stream().map(x -> String.format("%s (%s)", x.get("resource"), x.get("account"))).collect(Collectors.joining(", ")), ExceptionUtils.getMessageEx((Exception)ex)));
    }

    public static void postToQueueWithRetries(ResourceManager resourceManager, AzureStorageClient azureStorageClient, IngestionBlobInfo blob) throws IngestionClientException, IngestionServiceException, JsonProcessingException {
        ObjectMapper objectMapper = Utils.getObjectMapper();
        String message = objectMapper.writeValueAsString((Object)blob);
        ResourceAlgorithms.resourceActionWithRetries(resourceManager, resourceManager.getShuffledQueues(), queue -> {
            azureStorageClient.postMessageToQueue(queue.getQueue(), message);
            return null;
        }, "ResourceAlgorithms.postToQueueWithRetries", Collections.singletonMap("blob", SecurityUtils.removeSecretsFromUrl(blob.getBlobPath())));
    }

    public static UploadResult uploadStreamToBlobWithRetries(ResourceManager resourceManager, AzureStorageClient azureStorageClient, InputStream stream, String blobName, boolean shouldCompress) throws IngestionClientException, IngestionServiceException {
        return (UploadResult)ResourceAlgorithms.resourceActionWithRetries(resourceManager, resourceManager.getShuffledContainers(), container -> {
            int size = azureStorageClient.uploadStreamToBlob(stream, blobName, container.getContainer(), shouldCompress);
            UploadResult uploadResult = new UploadResult();
            uploadResult.blobPath = container.getContainer().getBlobContainerUrl() + "/" + blobName + container.getSas();
            uploadResult.size = size;
            return uploadResult;
        }, "ResourceAlgorithms.uploadLocalFileWithRetries", Collections.emptyMap());
    }

    public static String uploadLocalFileWithRetries(ResourceManager resourceManager, AzureStorageClient azureStorageClient, File file, String blobName, boolean shouldCompress) throws IngestionClientException, IngestionServiceException {
        return (String)ResourceAlgorithms.resourceActionWithRetries(resourceManager, resourceManager.getShuffledContainers(), container -> {
            azureStorageClient.uploadLocalFileToBlob(file, blobName, container.getContainer(), shouldCompress);
            return container.getContainer().getBlobContainerUrl() + "/" + blobName + container.getSas();
        }, "ResourceAlgorithms.uploadLocalFileWithRetries", Collections.emptyMap());
    }

    @NotNull
    public static <T> List<T> roundRobinNestedList(@NotNull List<List<T>> validResources) {
        int longestResourceList = validResources.stream().mapToInt(List::size).max().orElse(0);
        return IntStream.range(0, longestResourceList).boxed().flatMap(i -> validResources.stream().map(r -> r.size() > i ? r.get((int)i) : null).filter(Objects::nonNull)).collect(Collectors.toList());
    }

    public static <T extends ResourceWithSas<?>> List<T> getShuffledResources(List<RankedStorageAccount> shuffledAccounts, List<T> resourceOfType) {
        Map accountToResourcesMap = ResourceAlgorithms.groupResourceByAccountName(resourceOfType);
        List<List<T>> validResources = shuffledAccounts.stream().map(account -> (List)accountToResourcesMap.get(account.getAccountName())).filter(resourceList -> resourceList != null && !resourceList.isEmpty()).collect(Collectors.toList());
        return ResourceAlgorithms.roundRobinNestedList(validResources);
    }

    private static <T extends ResourceWithSas<?>> Map<String, List<T>> groupResourceByAccountName(List<T> resourceSet) {
        if (resourceSet == null || resourceSet.isEmpty()) {
            return Collections.emptyMap();
        }
        return resourceSet.stream().collect(Collectors.groupingBy(ResourceWithSas::getAccountName, Collectors.toList()));
    }

    public static class UploadResult {
        public String blobPath;
        public int size;
    }
}

