/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import com.microsoft.azure.kusto.ingest.source.FileSourceInfo;
import com.microsoft.azure.kusto.ingest.source.StreamSourceInfo;
import java.io.File;
import java.util.Map;
import java.util.UUID;

public class BlobSourceInfo
extends AbstractSourceInfo {
    private String blobPath;
    private Long blobExactSize = null;
    private CompressionType compressionType;

    public String getBlobPath() {
        return this.blobPath;
    }

    public void setBlobPath(String blobPath) {
        this.blobPath = blobPath;
    }

    public BlobSourceInfo(String blobPath) {
        this.blobPath = blobPath;
    }

    public BlobSourceInfo(String blobPath, CompressionType compressionType) {
        this(blobPath, compressionType, null);
    }

    public BlobSourceInfo(String blobPath, CompressionType compressionType, UUID sourceId) {
        this.setBlobPath(blobPath);
        this.setCompressionType(compressionType);
        this.setSourceId(sourceId);
    }

    public Long getBlobExactSize() {
        return this.blobExactSize;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    @Override
    public void validate() {
        Ensure.stringIsNotBlank((String)this.blobPath, (String)"blobPath");
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", this.blobPath);
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }

    public static BlobSourceInfo fromFile(String blobPath, FileSourceInfo fileSourceInfo, CompressionType sourceCompressionType, boolean gotCompressed) {
        BlobSourceInfo blobSourceInfo = new BlobSourceInfo(blobPath, gotCompressed ? CompressionType.gz : sourceCompressionType, fileSourceInfo.getSourceId());
        if (sourceCompressionType == null) {
            blobSourceInfo.blobExactSize = new File(fileSourceInfo.getFilePath()).length();
        }
        return blobSourceInfo;
    }

    public static BlobSourceInfo fromStream(String blobPath, Integer size, StreamSourceInfo streamSourceInfo) {
        BlobSourceInfo blobSourceInfo = new BlobSourceInfo(blobPath, streamSourceInfo.getCompressionType(), streamSourceInfo.getSourceId());
        blobSourceInfo.blobExactSize = size.longValue();
        return blobSourceInfo;
    }
}

