/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import java.util.Map;
import java.util.UUID;

public class FileSourceInfo
extends AbstractSourceInfo {
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FileSourceInfo(String filePath) {
        this.filePath = filePath;
    }

    public FileSourceInfo(String filePath, UUID sourceId) {
        this(filePath);
        this.setSourceId(sourceId);
    }

    @Override
    public void validate() {
        Ensure.stringIsNotBlank((String)this.filePath, (String)"filePath");
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", this.filePath);
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }
}

