/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.source;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.ingest.source.AbstractSourceInfo;
import com.microsoft.azure.kusto.ingest.source.CompressionType;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class StreamSourceInfo
extends AbstractSourceInfo {
    private InputStream stream;
    private boolean leaveOpen = false;
    private CompressionType compressionType = null;

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream cannot be null");
    }

    public boolean isLeaveOpen() {
        return this.leaveOpen;
    }

    public void setLeaveOpen(boolean leaveOpen) {
        this.leaveOpen = leaveOpen;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public StreamSourceInfo(InputStream stream) {
        this.setStream(stream);
    }

    public StreamSourceInfo(InputStream stream, boolean leaveOpen) {
        this(stream);
        this.setLeaveOpen(leaveOpen);
    }

    public StreamSourceInfo(InputStream stream, boolean leaveOpen, UUID sourceId) {
        this(stream, leaveOpen);
        this.setSourceId(sourceId);
    }

    public StreamSourceInfo(InputStream stream, boolean leaveOpen, UUID sourceId, CompressionType compressionType) {
        this(stream, leaveOpen, sourceId);
        this.setCompressionType(compressionType);
    }

    @Override
    public void validate() {
        Ensure.argIsNotNull((Object)this.stream, (String)"stream");
        Ensure.isTrue((this.compressionType != CompressionType.zip ? 1 : 0) != 0, (String)"streaming ingest is not working with zip compression");
    }

    public String toString() {
        return String.format("Stream with SourceId: %s", this.getSourceId());
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        attributes.put("resource", "stream");
        UUID sourceId = this.getSourceId();
        if (sourceId != null) {
            attributes.put("sourceId", sourceId.toString());
        }
        return attributes;
    }
}

