/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions;

import com.microsoft.aad.msal4jextensions.CacheFileLockAcquisitionException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CrossProcessCacheFileLock {
    private static final Logger LOG = LoggerFactory.getLogger(CrossProcessCacheFileLock.class);
    public static final String READ_MODE = "r";
    public static final String WRITE_MODE = "rw";
    private int retryDelayMilliseconds;
    private int retryNumber;
    private File lockFile;
    private RandomAccessFile randomAccessFile;
    private String mode;
    private FileLock lock;

    CrossProcessCacheFileLock(String lockfileName, int retryDelayMilliseconds, int retryNumber) {
        this.lockFile = new File(lockfileName);
        this.lockFile.deleteOnExit();
        this.retryDelayMilliseconds = retryDelayMilliseconds;
        this.retryNumber = retryNumber;
    }

    void readLock() throws CacheFileLockAcquisitionException {
        this.lock(READ_MODE);
    }

    void writeLock() throws CacheFileLockAcquisitionException {
        this.lock(WRITE_MODE);
    }

    private String getProcessId() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        String pid = vmName.substring(0, vmName.indexOf("@"));
        return pid;
    }

    private String getLockProcessThreadId() {
        return "pid:" + this.getProcessId() + " thread:" + Thread.currentThread().getId();
    }

    private void lock(String mode) throws CacheFileLockAcquisitionException {
        for (int tryCount = 0; tryCount < this.retryNumber; ++tryCount) {
            try {
                this.lockFile.createNewFile();
                LOG.debug(this.getLockProcessThreadId() + " acquiring " + mode + " file lock");
                this.randomAccessFile = new RandomAccessFile(this.lockFile, mode);
                FileChannel channel = this.randomAccessFile.getChannel();
                boolean isShared = READ_MODE.equals(mode);
                this.lock = channel.lock(0L, Long.MAX_VALUE, isShared);
                this.mode = mode;
                if (!this.lock.isShared()) {
                    String jvmName = ManagementFactory.getRuntimeMXBean().getName();
                    ByteBuffer buff = ByteBuffer.wrap(jvmName.replace("@", " ").getBytes(StandardCharsets.UTF_8));
                    channel.write(buff);
                }
                LOG.debug(this.getLockProcessThreadId() + " acquired file lock, isShared - " + this.lock.isShared());
                return;
            }
            catch (Exception ex) {
                LOG.debug(this.getLockProcessThreadId() + " failed to acquire " + mode + " lock, exception msg - " + ex.getMessage());
                try {
                    this.releaseResources();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
                try {
                    Thread.sleep(this.retryDelayMilliseconds);
                }
                catch (InterruptedException e) {
                    LOG.error(e.getMessage());
                }
                continue;
            }
        }
        LOG.error(this.getLockProcessThreadId() + " failed to acquire " + mode + " lock");
        throw new CacheFileLockAcquisitionException(this.getLockProcessThreadId() + " failed to acquire " + mode + " lock");
    }

    void unlock() throws IOException {
        LOG.debug(this.getLockProcessThreadId() + " releasing " + this.mode + " lock");
        this.releaseResources();
    }

    private void releaseResources() throws IOException {
        if (this.lock != null) {
            this.lock.release();
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
    }
}

