/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions;

import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import com.microsoft.aad.msal4jextensions.CrossProcessCacheFileLock;
import com.microsoft.aad.msal4jextensions.PersistenceSettings;
import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.microsoft.aad.msal4jextensions.persistence.linux.KeyRingAccessor;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.nimbusds.jose.util.StandardCharset;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceTokenCacheAccessAspect
implements ITokenCacheAccessAspect {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceTokenCacheAccessAspect.class);
    private CrossProcessCacheFileLock lock;
    private Long lastSeenCacheFileModifiedTimestamp;
    private ICacheAccessor cacheAccessor;
    private PersistenceSettings parameters;

    private String getCacheLockFilePath() {
        return this.parameters.getCacheDirectoryPath() + File.separator + ".lock";
    }

    private String getCacheFilePath() {
        return this.parameters.getCacheDirectoryPath() + File.separator + this.parameters.getCacheFileName();
    }

    private void createCacheFileIfNotExist() throws IOException {
        Files.createDirectories(this.parameters.getCacheDirectoryPath(), new FileAttribute[0]);
        if (new File(this.getCacheFilePath()).createNewFile()) {
            LOG.debug("MSAL cache file was created, path - " + this.getCacheFilePath());
        }
    }

    public PersistenceTokenCacheAccessAspect(PersistenceSettings persistenceSettings) throws IOException {
        this.parameters = persistenceSettings;
        this.createCacheFileIfNotExist();
        String cacheFilePath = this.getCacheFilePath();
        this.lock = new CrossProcessCacheFileLock(this.getCacheLockFilePath(), persistenceSettings.getLockRetryDelayMilliseconds(), persistenceSettings.getLockRetryNumber());
        if (Platform.isMac()) {
            this.cacheAccessor = new KeyChainAccessor(cacheFilePath, this.parameters.getKeychainService(), this.parameters.getKeychainAccount());
        } else if (Platform.isWindows()) {
            this.cacheAccessor = new CacheFileAccessor(cacheFilePath);
        } else if (Platform.isLinux()) {
            if (this.parameters.isOnLinuxUseUnprotectedFileAsCacheStorage()) {
                this.cacheAccessor = new CacheFileAccessor(cacheFilePath);
            } else {
                this.cacheAccessor = new KeyRingAccessor(cacheFilePath, this.parameters.getKeyringCollection(), this.parameters.getKeyringSchemaName(), this.parameters.getKeyringSecretLabel(), this.parameters.getKeyringAttribute1Key(), this.parameters.getKeyringAttribute1Value(), this.parameters.getKeyringAttribute2Key(), this.parameters.getKeyringAttribute2Value());
                ((KeyRingAccessor)this.cacheAccessor).verify();
            }
        }
    }

    private boolean isWriteAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        return iTokenCacheAccessContext.hasCacheChanged();
    }

    private boolean isReadAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        return !this.isWriteAccess(iTokenCacheAccessContext);
    }

    private void updateLastSeenCacheFileModifiedTimestamp() throws IOException {
        this.lastSeenCacheFileModifiedTimestamp = this.getCurrentCacheFileModifiedTimestamp();
    }

    public Long getCurrentCacheFileModifiedTimestamp() {
        return new File(this.getCacheFilePath()).lastModified();
    }

    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        try {
            if (this.isWriteAccess(iTokenCacheAccessContext)) {
                this.lock.writeLock();
            } else {
                Long currentCacheFileModifiedTimestamp = this.getCurrentCacheFileModifiedTimestamp();
                if (currentCacheFileModifiedTimestamp != null && currentCacheFileModifiedTimestamp.equals(this.lastSeenCacheFileModifiedTimestamp)) {
                    return;
                }
                this.lock.readLock();
            }
            byte[] data = this.cacheAccessor.read();
            if (data != null) {
                iTokenCacheAccessContext.tokenCache().deserialize(new String(data, StandardCharset.UTF_8));
            }
            this.updateLastSeenCacheFileModifiedTimestamp();
            if (this.isReadAccess(iTokenCacheAccessContext)) {
                this.lock.unlock();
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
    }

    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        try {
            if (this.isWriteAccess(iTokenCacheAccessContext)) {
                this.cacheAccessor.write(iTokenCacheAccessContext.tokenCache().serialize().getBytes(StandardCharset.UTF_8));
                this.updateLastSeenCacheFileModifiedTimestamp();
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
        finally {
            try {
                this.lock.unlock();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }
}

