/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions.persistence;

import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessException;
import com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Crypt32Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;

public class CacheFileAccessor
implements ICacheAccessor {
    private String cacheFilePath;
    private File cacheFile;

    public CacheFileAccessor(String cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
        this.cacheFile = new File(cacheFilePath);
    }

    @Override
    public byte[] read() {
        byte[] data = null;
        if (this.cacheFile.exists()) {
            try {
                data = Files.readAllBytes(this.cacheFile.toPath());
            }
            catch (IOException e) {
                throw new CacheFileAccessException("Failed to read Cache File", e);
            }
            if (data != null && data.length > 0 && Platform.isWindows()) {
                data = Crypt32Util.cryptUnprotectData((byte[])data);
            }
        }
        return data;
    }

    @Override
    public void write(byte[] data) {
        if (Platform.isWindows()) {
            data = Crypt32Util.cryptProtectData((byte[])data);
        }
        try (FileOutputStream stream = new FileOutputStream(this.cacheFilePath);){
            stream.write(data);
        }
        catch (IOException e) {
            throw new CacheFileAccessException("Failed to write to Cache File", e);
        }
    }

    @Override
    public void delete() {
        try {
            Files.deleteIfExists(new File(this.cacheFilePath).toPath());
        }
        catch (IOException e) {
            throw new CacheFileAccessException("Failed to delete Cache File", e);
        }
    }

    public void updateCacheFileLastModifiedTimeByWritingDummyData() {
        this.write(new byte[1]);
    }
}

