/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4jextensions.persistence.mac;

import com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.microsoft.aad.msal4jextensions.persistence.mac.ISecurityLibrary;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessException;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;

public class KeyChainAccessor
implements ICacheAccessor {
    private String cacheFilePath;
    private byte[] serviceNameBytes;
    private byte[] accountNameBytes;

    public KeyChainAccessor(String cacheFilePath, String serviceName, String accountName) {
        this.cacheFilePath = cacheFilePath;
        this.serviceNameBytes = serviceName.getBytes(StandardCharsets.UTF_8);
        this.accountNameBytes = accountName.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read() {
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        try {
            int status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, dataLength, data, null);
            if (status == -25300) {
                byte[] byArray = null;
                return byArray;
            }
            if (status != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            byte[] byArray = data[0].getByteArray(0L, dataLength[0]);
            return byArray;
        }
        finally {
            ISecurityLibrary.library.SecKeychainItemFreeContent(null, data[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] data) {
        Pointer[] itemRef = new Pointer[1];
        try {
            int status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, null, null, itemRef);
            if (status != 0 && status != -25300) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            status = itemRef[0] != null ? ISecurityLibrary.library.SecKeychainItemModifyContent(itemRef[0], null, data.length, data) : ISecurityLibrary.library.SecKeychainAddGenericPassword(Pointer.NULL, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, data.length, data, null);
            if (status != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTimeByWritingDummyData();
        }
        finally {
            if (itemRef[0] != null) {
                ISecurityLibrary.library.CFRelease(itemRef[0]);
            }
        }
    }

    @Override
    public void delete() {
        Pointer[] itemRef = new Pointer[1];
        try {
            int status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, null, null, itemRef);
            if (status == -25300) {
                return;
            }
            if (status != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            if (itemRef[0] != null && (status = ISecurityLibrary.library.SecKeychainItemDelete(itemRef[0])) != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTimeByWritingDummyData();
        }
        finally {
            if (itemRef[0] != null) {
                ISecurityLibrary.library.CFRelease(itemRef[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertErrorCodeToMessage(int errorCode) {
        Pointer msgPtr = null;
        try {
            msgPtr = ISecurityLibrary.library.SecCopyErrorMessageString(errorCode, null);
            if (msgPtr == null) {
                String string = null;
                return string;
            }
            int bufSize = ISecurityLibrary.library.CFStringGetLength(msgPtr);
            char[] buf = new char[bufSize];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = ISecurityLibrary.library.CFStringGetCharacterAtIndex(msgPtr, i);
            }
            String string = new String(buf);
            return string;
        }
        finally {
            if (msgPtr != null) {
                ISecurityLibrary.library.CFRelease(msgPtr);
            }
        }
    }
}

