/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.net.URI;
import java.util.Set;
import lombok.NonNull;

public class AuthorizationCodeParameters {
    private Set<String> scopes;
    @NonNull
    private String authorizationCode;
    @NonNull
    private URI redirectUri;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        ParameterValidationUtils.validateNotBlank("authorizationCode", authorizationCode);
        return AuthorizationCodeParameters.builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }

    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String authorizationCode() {
        return this.authorizationCode;
    }

    @NonNull
    public URI redirectUri() {
        return this.redirectUri;
    }

    private AuthorizationCodeParameters(Set<String> scopes, @NonNull String authorizationCode, @NonNull URI redirectUri) {
        if (authorizationCode == null) {
            throw new NullPointerException("authorizationCode is marked @NonNull but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
    }

    public static class AuthorizationCodeParametersBuilder {
        private Set<String> scopes;
        private String authorizationCode;
        private URI redirectUri;

        AuthorizationCodeParametersBuilder() {
        }

        public AuthorizationCodeParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public AuthorizationCodeParametersBuilder authorizationCode(@NonNull String authorizationCode) {
            if (authorizationCode == null) {
                throw new NullPointerException("authorizationCode is marked @NonNull but is null");
            }
            this.authorizationCode = authorizationCode;
            return this;
        }

        public AuthorizationCodeParametersBuilder redirectUri(@NonNull URI redirectUri) {
            if (redirectUri == null) {
                throw new NullPointerException("redirectUri is marked @NonNull but is null");
            }
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(this.scopes, this.authorizationCode, this.redirectUri);
        }

        public String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(scopes=" + this.scopes + ", authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ")";
        }
    }
}

