// Generated by delombok at Mon Apr 26 22:49:20 UTC 2021
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import com.nimbusds.jwt.JWTParser;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;

final class AuthenticationResult implements IAuthenticationResult {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final long expiresOn;
    private final long extExpiresOn;
    private final String refreshToken;
    private final Long refreshOn;
    private final String familyId;
    private final String idToken;
    private final java.util.concurrent.atomic.AtomicReference<java.lang.Object> idTokenObject = new java.util.concurrent.atomic.AtomicReference<java.lang.Object>();

    private IdToken getIdTokenObj() {
        if (StringHelper.isBlank(idToken)) {
            return null;
        }
        try {
            String idTokenJson = JWTParser.parse(idToken).getParsedParts()[1].decodeToString();
            return JsonHelper.convertJsonToObject(idTokenJson, IdToken.class);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    private final AccountCacheEntity accountCacheEntity;
    private final java.util.concurrent.atomic.AtomicReference<java.lang.Object> account = new java.util.concurrent.atomic.AtomicReference<java.lang.Object>();

    private IAccount getAccount() {
        if (accountCacheEntity == null) {
            return null;
        }
        return accountCacheEntity.toAccount();
    }

    private final java.util.concurrent.atomic.AtomicReference<java.lang.Object> tenantProfile = new java.util.concurrent.atomic.AtomicReference<java.lang.Object>();

    private ITenantProfile getTenantProfile() {
        if (StringHelper.isBlank(idToken)) {
            return null;
        }
        try {
            return new TenantProfile(JWTParser.parse(idToken).getJWTClaimsSet().getClaims(), getAccount().environment());
        } catch (ParseException e) {
            throw new MsalClientException("Cached JWT could not be parsed: " + e.getMessage(), AuthenticationErrorCode.INVALID_JWT);
        }
    }

    private String environment;
    private final java.util.concurrent.atomic.AtomicReference<java.lang.Object> expiresOnDate = new java.util.concurrent.atomic.AtomicReference<java.lang.Object>();
    private final String scopes;

    @java.lang.SuppressWarnings("all")
    AuthenticationResult(final String accessToken, final long expiresOn, final long extExpiresOn, final String refreshToken, final Long refreshOn, final String familyId, final String idToken, final AccountCacheEntity accountCacheEntity, final String environment, final String scopes) {
        this.accessToken = accessToken;
        this.expiresOn = expiresOn;
        this.extExpiresOn = extExpiresOn;
        this.refreshToken = refreshToken;
        this.refreshOn = refreshOn;
        this.familyId = familyId;
        this.idToken = idToken;
        this.accountCacheEntity = accountCacheEntity;
        this.environment = environment;
        this.scopes = scopes;
    }


    @java.lang.SuppressWarnings("all")
    public static class AuthenticationResultBuilder {
        @java.lang.SuppressWarnings("all")
        private String accessToken;
        @java.lang.SuppressWarnings("all")
        private long expiresOn;
        @java.lang.SuppressWarnings("all")
        private long extExpiresOn;
        @java.lang.SuppressWarnings("all")
        private String refreshToken;
        @java.lang.SuppressWarnings("all")
        private Long refreshOn;
        @java.lang.SuppressWarnings("all")
        private String familyId;
        @java.lang.SuppressWarnings("all")
        private String idToken;
        @java.lang.SuppressWarnings("all")
        private AccountCacheEntity accountCacheEntity;
        @java.lang.SuppressWarnings("all")
        private String environment;
        @java.lang.SuppressWarnings("all")
        private String scopes;

        @java.lang.SuppressWarnings("all")
        AuthenticationResultBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder accessToken(final String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder expiresOn(final long expiresOn) {
            this.expiresOn = expiresOn;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder extExpiresOn(final long extExpiresOn) {
            this.extExpiresOn = extExpiresOn;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder refreshToken(final String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder refreshOn(final Long refreshOn) {
            this.refreshOn = refreshOn;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder familyId(final String familyId) {
            this.familyId = familyId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder idToken(final String idToken) {
            this.idToken = idToken;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder accountCacheEntity(final AccountCacheEntity accountCacheEntity) {
            this.accountCacheEntity = accountCacheEntity;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder environment(final String environment) {
            this.environment = environment;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResultBuilder scopes(final String scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthenticationResult build() {
            return new AuthenticationResult(accessToken, expiresOn, extExpiresOn, refreshToken, refreshOn, familyId, idToken, accountCacheEntity, environment, scopes);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "AuthenticationResult.AuthenticationResultBuilder(accessToken=" + this.accessToken + ", expiresOn=" + this.expiresOn + ", extExpiresOn=" + this.extExpiresOn + ", refreshToken=" + this.refreshToken + ", refreshOn=" + this.refreshOn + ", familyId=" + this.familyId + ", idToken=" + this.idToken + ", accountCacheEntity=" + this.accountCacheEntity + ", environment=" + this.environment + ", scopes=" + this.scopes + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    public static AuthenticationResultBuilder builder() {
        return new AuthenticationResultBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public String accessToken() {
        return this.accessToken;
    }

    @java.lang.SuppressWarnings("all")
    public String refreshToken() {
        return this.refreshToken;
    }

    @java.lang.SuppressWarnings("all")
    public Long refreshOn() {
        return this.refreshOn;
    }

    @java.lang.SuppressWarnings("all")
    public String idToken() {
        return this.idToken;
    }

    @java.lang.SuppressWarnings("all")
    public String environment() {
        return this.environment;
    }

    @java.lang.SuppressWarnings("all")
    public String scopes() {
        return this.scopes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AuthenticationResult)) return false;
        final AuthenticationResult other = (AuthenticationResult) o;
        final java.lang.Object this$accessToken = this.accessToken();
        final java.lang.Object other$accessToken = other.accessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) return false;
        if (this.expiresOn() != other.expiresOn()) return false;
        if (this.extExpiresOn() != other.extExpiresOn()) return false;
        final java.lang.Object this$refreshToken = this.refreshToken();
        final java.lang.Object other$refreshToken = other.refreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) return false;
        final java.lang.Object this$refreshOn = this.refreshOn();
        final java.lang.Object other$refreshOn = other.refreshOn();
        if (this$refreshOn == null ? other$refreshOn != null : !this$refreshOn.equals(other$refreshOn)) return false;
        final java.lang.Object this$familyId = this.familyId();
        final java.lang.Object other$familyId = other.familyId();
        if (this$familyId == null ? other$familyId != null : !this$familyId.equals(other$familyId)) return false;
        final java.lang.Object this$idToken = this.idToken();
        final java.lang.Object other$idToken = other.idToken();
        if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) return false;
        final java.lang.Object this$idTokenObject = this.idTokenObject();
        final java.lang.Object other$idTokenObject = other.idTokenObject();
        if (this$idTokenObject == null ? other$idTokenObject != null : !this$idTokenObject.equals(other$idTokenObject)) return false;
        final java.lang.Object this$accountCacheEntity = this.accountCacheEntity();
        final java.lang.Object other$accountCacheEntity = other.accountCacheEntity();
        if (this$accountCacheEntity == null ? other$accountCacheEntity != null : !this$accountCacheEntity.equals(other$accountCacheEntity)) return false;
        final java.lang.Object this$account = this.account();
        final java.lang.Object other$account = other.account();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) return false;
        final java.lang.Object this$tenantProfile = this.tenantProfile();
        final java.lang.Object other$tenantProfile = other.tenantProfile();
        if (this$tenantProfile == null ? other$tenantProfile != null : !this$tenantProfile.equals(other$tenantProfile)) return false;
        final java.lang.Object this$environment = this.environment();
        final java.lang.Object other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) return false;
        final java.lang.Object this$expiresOnDate = this.expiresOnDate();
        final java.lang.Object other$expiresOnDate = other.expiresOnDate();
        if (this$expiresOnDate == null ? other$expiresOnDate != null : !this$expiresOnDate.equals(other$expiresOnDate)) return false;
        final java.lang.Object this$scopes = this.scopes();
        final java.lang.Object other$scopes = other.scopes();
        if (this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $accessToken = this.accessToken();
        result = result * PRIME + ($accessToken == null ? 43 : $accessToken.hashCode());
        final long $expiresOn = this.expiresOn();
        result = result * PRIME + (int) ($expiresOn >>> 32 ^ $expiresOn);
        final long $extExpiresOn = this.extExpiresOn();
        result = result * PRIME + (int) ($extExpiresOn >>> 32 ^ $extExpiresOn);
        final java.lang.Object $refreshToken = this.refreshToken();
        result = result * PRIME + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        final java.lang.Object $refreshOn = this.refreshOn();
        result = result * PRIME + ($refreshOn == null ? 43 : $refreshOn.hashCode());
        final java.lang.Object $familyId = this.familyId();
        result = result * PRIME + ($familyId == null ? 43 : $familyId.hashCode());
        final java.lang.Object $idToken = this.idToken();
        result = result * PRIME + ($idToken == null ? 43 : $idToken.hashCode());
        final java.lang.Object $idTokenObject = this.idTokenObject();
        result = result * PRIME + ($idTokenObject == null ? 43 : $idTokenObject.hashCode());
        final java.lang.Object $accountCacheEntity = this.accountCacheEntity();
        result = result * PRIME + ($accountCacheEntity == null ? 43 : $accountCacheEntity.hashCode());
        final java.lang.Object $account = this.account();
        result = result * PRIME + ($account == null ? 43 : $account.hashCode());
        final java.lang.Object $tenantProfile = this.tenantProfile();
        result = result * PRIME + ($tenantProfile == null ? 43 : $tenantProfile.hashCode());
        final java.lang.Object $environment = this.environment();
        result = result * PRIME + ($environment == null ? 43 : $environment.hashCode());
        final java.lang.Object $expiresOnDate = this.expiresOnDate();
        result = result * PRIME + ($expiresOnDate == null ? 43 : $expiresOnDate.hashCode());
        final java.lang.Object $scopes = this.scopes();
        result = result * PRIME + ($scopes == null ? 43 : $scopes.hashCode());
        return result;
    }

    @java.lang.SuppressWarnings("all")
    long expiresOn() {
        return this.expiresOn;
    }

    @java.lang.SuppressWarnings("all")
    long extExpiresOn() {
        return this.extExpiresOn;
    }

    @java.lang.SuppressWarnings("all")
    String familyId() {
        return this.familyId;
    }

    @java.lang.SuppressWarnings("all")
    IdToken idTokenObject() {
        java.lang.Object value = this.idTokenObject.get();
        if (value == null) {
            synchronized (this.idTokenObject) {
                value = this.idTokenObject.get();
                if (value == null) {
                    final IdToken actualValue = getIdTokenObj();
                    value = actualValue == null ? this.idTokenObject : actualValue;
                    this.idTokenObject.set(value);
                }
            }
        }
        return (IdToken) (value == this.idTokenObject ? null : value);
    }

    @java.lang.SuppressWarnings("all")
    AccountCacheEntity accountCacheEntity() {
        return this.accountCacheEntity;
    }

    @java.lang.SuppressWarnings("all")
    public IAccount account() {
        java.lang.Object value = this.account.get();
        if (value == null) {
            synchronized (this.account) {
                value = this.account.get();
                if (value == null) {
                    final IAccount actualValue = getAccount();
                    value = actualValue == null ? this.account : actualValue;
                    this.account.set(value);
                }
            }
        }
        return (IAccount) (value == this.account ? null : value);
    }

    @java.lang.SuppressWarnings("all")
    public ITenantProfile tenantProfile() {
        java.lang.Object value = this.tenantProfile.get();
        if (value == null) {
            synchronized (this.tenantProfile) {
                value = this.tenantProfile.get();
                if (value == null) {
                    final ITenantProfile actualValue = getTenantProfile();
                    value = actualValue == null ? this.tenantProfile : actualValue;
                    this.tenantProfile.set(value);
                }
            }
        }
        return (ITenantProfile) (value == this.tenantProfile ? null : value);
    }

    @java.lang.SuppressWarnings("all")
    public Date expiresOnDate() {
        java.lang.Object value = this.expiresOnDate.get();
        if (value == null) {
            synchronized (this.expiresOnDate) {
                value = this.expiresOnDate.get();
                if (value == null) {
                    final Date actualValue = new Date(expiresOn * 1000);
                    value = actualValue == null ? this.expiresOnDate : actualValue;
                    this.expiresOnDate.set(value);
                }
            }
        }
        return (Date) (value == this.expiresOnDate ? null : value);
    }
}
