// Generated by delombok at Mon Apr 26 22:49:20 UTC 2021
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for On-Behalf-Of flow. Can be used as parameter to

 * {@link ConfidentialClientApplication#acquireToken(OnBehalfOfParameters)}

 *

 * For more details, see https://aka.ms/msal4j-on-behalf-of
 */
public class OnBehalfOfParameters implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is

     * set to false.
     */
    private Boolean skipCache;
    @NonNull
    private IUserAssertion userAssertion;

    private static OnBehalfOfParametersBuilder builder() {
        return new OnBehalfOfParametersBuilder();
    }

    /**
     * Builder for {@link OnBehalfOfParameters}

     * @param scopes scopes application is requesting access to

     * @param userAssertion {@link UserAssertion} created from access token received

     * @return builder that can be used to construct OnBehalfOfParameters
     */
    public static OnBehalfOfParametersBuilder builder(Set<String> scopes, UserAssertion userAssertion) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes).userAssertion(userAssertion);
    }

    @java.lang.SuppressWarnings("all")
    private static Boolean $default$skipCache() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    public static class OnBehalfOfParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private boolean skipCache$set;
        @java.lang.SuppressWarnings("all")
        private Boolean skipCache;
        @java.lang.SuppressWarnings("all")
        private IUserAssertion userAssertion;

        @java.lang.SuppressWarnings("all")
        OnBehalfOfParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder skipCache(final Boolean skipCache) {
            this.skipCache = skipCache;
            skipCache$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParametersBuilder userAssertion(final IUserAssertion userAssertion) {
            this.userAssertion = userAssertion;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public OnBehalfOfParameters build() {
            Boolean skipCache = this.skipCache;
            if (!skipCache$set) skipCache = OnBehalfOfParameters.$default$skipCache();
            return new OnBehalfOfParameters(scopes, claims, skipCache, userAssertion);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "OnBehalfOfParameters.OnBehalfOfParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ", skipCache=" + this.skipCache + ", userAssertion=" + this.userAssertion + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Indicates whether the request should skip looking into the token cache. Be default it is

     * set to false.
     */
    @java.lang.SuppressWarnings("all")
    public Boolean skipCache() {
        return this.skipCache;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public IUserAssertion userAssertion() {
        return this.userAssertion;
    }

    @java.lang.SuppressWarnings("all")
    private OnBehalfOfParameters(@NonNull final Set<String> scopes, final ClaimsRequest claims, final Boolean skipCache, @NonNull final IUserAssertion userAssertion) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (userAssertion == null) {
            throw new java.lang.NullPointerException("userAssertion is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
        this.skipCache = skipCache;
        this.userAssertion = userAssertion;
    }
}
