// Generated by delombok at Fri Jul 16 13:56:07 UTC 2021
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class AccountCacheEntity implements Serializable {
    static final String MSSTS_ACCOUNT_TYPE = "MSSTS";
    static final String ADFS_ACCOUNT_TYPE = "ADFS";
    @JsonProperty("home_account_id")
    protected String homeAccountId;
    @JsonProperty("environment")
    protected String environment;
    @JsonProperty("realm")
    protected String realm;
    @JsonProperty("local_account_id")
    protected String localAccountId;
    @JsonProperty("username")
    protected String username;
    @JsonProperty("name")
    protected String name;
    @JsonProperty("client_info")
    protected String clientInfoStr;
    @JsonProperty("user_assertion_hash")
    protected String userAssertionHash;

    ClientInfo clientInfo() {
        return ClientInfo.createFromJson(clientInfoStr);
    }

    @JsonProperty("authority_type")
    protected String authorityType;

    String getKey() {
        List<String> keyParts = new ArrayList<>();
        keyParts.add(homeAccountId);
        keyParts.add(environment);
        keyParts.add(StringHelper.isBlank(realm) ? "" : realm);
        return String.join(Constants.CACHE_KEY_SEPARATOR, keyParts).toLowerCase();
    }

    static AccountCacheEntity create(String clientInfoStr, Authority requestAuthority, IdToken idToken, String policy) {
        AccountCacheEntity account = new AccountCacheEntity();
        account.authorityType(MSSTS_ACCOUNT_TYPE);
        account.clientInfoStr = clientInfoStr;
        account.homeAccountId(policy != null ? account.clientInfo().toAccountIdentifier() + Constants.CACHE_KEY_SEPARATOR + policy : account.clientInfo().toAccountIdentifier());
        account.environment(requestAuthority.host());
        account.realm(requestAuthority.tenant());
        if (idToken != null) {
            String localAccountId = !StringHelper.isBlank(idToken.objectIdentifier) ? idToken.objectIdentifier : idToken.subject;
            account.localAccountId(localAccountId);
            account.username(idToken.preferredUsername);
            account.name(idToken.name);
        }
        return account;
    }

    static AccountCacheEntity createADFSAccount(Authority requestAuthority, IdToken idToken) {
        AccountCacheEntity account = new AccountCacheEntity();
        account.authorityType(ADFS_ACCOUNT_TYPE);
        account.homeAccountId(idToken.subject);
        account.environment(requestAuthority.host());
        account.username(idToken.upn);
        account.name(idToken.uniqueName);
        return account;
    }

    static AccountCacheEntity create(String clientInfoStr, Authority requestAuthority, IdToken idToken) {
        return create(clientInfoStr, requestAuthority, idToken, null);
    }

    IAccount toAccount() {
        return new Account(homeAccountId, environment, username, null);
    }

    @java.lang.SuppressWarnings("all")
    public String homeAccountId() {
        return this.homeAccountId;
    }

    @java.lang.SuppressWarnings("all")
    public String environment() {
        return this.environment;
    }

    @java.lang.SuppressWarnings("all")
    public String realm() {
        return this.realm;
    }

    @java.lang.SuppressWarnings("all")
    public String localAccountId() {
        return this.localAccountId;
    }

    @java.lang.SuppressWarnings("all")
    public String username() {
        return this.username;
    }

    @java.lang.SuppressWarnings("all")
    public String name() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    public String clientInfoStr() {
        return this.clientInfoStr;
    }

    @java.lang.SuppressWarnings("all")
    public String userAssertionHash() {
        return this.userAssertionHash;
    }

    @java.lang.SuppressWarnings("all")
    public String authorityType() {
        return this.authorityType;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity homeAccountId(final String homeAccountId) {
        this.homeAccountId = homeAccountId;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity environment(final String environment) {
        this.environment = environment;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity realm(final String realm) {
        this.realm = realm;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity localAccountId(final String localAccountId) {
        this.localAccountId = localAccountId;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity username(final String username) {
        this.username = username;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity name(final String name) {
        this.name = name;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity clientInfoStr(final String clientInfoStr) {
        this.clientInfoStr = clientInfoStr;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity userAssertionHash(final String userAssertionHash) {
        this.userAssertionHash = userAssertionHash;
        return this;
    }

    @java.lang.SuppressWarnings("all")
    public AccountCacheEntity authorityType(final String authorityType) {
        this.authorityType = authorityType;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AccountCacheEntity)) return false;
        final AccountCacheEntity other = (AccountCacheEntity) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$homeAccountId = this.homeAccountId();
        final java.lang.Object other$homeAccountId = other.homeAccountId();
        if (this$homeAccountId == null ? other$homeAccountId != null : !this$homeAccountId.equals(other$homeAccountId)) return false;
        final java.lang.Object this$environment = this.environment();
        final java.lang.Object other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) return false;
        final java.lang.Object this$realm = this.realm();
        final java.lang.Object other$realm = other.realm();
        if (this$realm == null ? other$realm != null : !this$realm.equals(other$realm)) return false;
        final java.lang.Object this$localAccountId = this.localAccountId();
        final java.lang.Object other$localAccountId = other.localAccountId();
        if (this$localAccountId == null ? other$localAccountId != null : !this$localAccountId.equals(other$localAccountId)) return false;
        final java.lang.Object this$username = this.username();
        final java.lang.Object other$username = other.username();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        final java.lang.Object this$name = this.name();
        final java.lang.Object other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$clientInfoStr = this.clientInfoStr();
        final java.lang.Object other$clientInfoStr = other.clientInfoStr();
        if (this$clientInfoStr == null ? other$clientInfoStr != null : !this$clientInfoStr.equals(other$clientInfoStr)) return false;
        final java.lang.Object this$userAssertionHash = this.userAssertionHash();
        final java.lang.Object other$userAssertionHash = other.userAssertionHash();
        if (this$userAssertionHash == null ? other$userAssertionHash != null : !this$userAssertionHash.equals(other$userAssertionHash)) return false;
        final java.lang.Object this$authorityType = this.authorityType();
        final java.lang.Object other$authorityType = other.authorityType();
        if (this$authorityType == null ? other$authorityType != null : !this$authorityType.equals(other$authorityType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AccountCacheEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $homeAccountId = this.homeAccountId();
        result = result * PRIME + ($homeAccountId == null ? 43 : $homeAccountId.hashCode());
        final java.lang.Object $environment = this.environment();
        result = result * PRIME + ($environment == null ? 43 : $environment.hashCode());
        final java.lang.Object $realm = this.realm();
        result = result * PRIME + ($realm == null ? 43 : $realm.hashCode());
        final java.lang.Object $localAccountId = this.localAccountId();
        result = result * PRIME + ($localAccountId == null ? 43 : $localAccountId.hashCode());
        final java.lang.Object $username = this.username();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        final java.lang.Object $name = this.name();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $clientInfoStr = this.clientInfoStr();
        result = result * PRIME + ($clientInfoStr == null ? 43 : $clientInfoStr.hashCode());
        final java.lang.Object $userAssertionHash = this.userAssertionHash();
        result = result * PRIME + ($userAssertionHash == null ? 43 : $userAssertionHash.hashCode());
        final java.lang.Object $authorityType = this.authorityType();
        result = result * PRIME + ($authorityType == null ? 43 : $authorityType.hashCode());
        return result;
    }
}
