// Generated by delombok at Wed Jun 29 16:39:07 UTC 2022
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;

/**
 * Object containing parameters for authorization code flow. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(AuthorizationCodeParameters)} or to

 * {@link ConfidentialClientApplication#acquireToken(AuthorizationCodeParameters)}
 */
public class AuthorizationCodeParameters implements IAcquireTokenParameters {
    /**
     * Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more

     * details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    private String authorizationCode;
    /**
     * Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0

     * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    private URI redirectUri;
    /**
     * Scopes to which the application is requesting access
     */
    private Set<String> scopes;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
     */
    private String codeVerifier;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    /**
     * Builder for {@link AuthorizationCodeParameters}

     *

     * @param authorizationCode code received from the service authorization endpoint

     * @param redirectUri       URI where authorization code was received

     * @return builder object that can be used to construct {@link AuthorizationCodeParameters}
     */
    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        validateNotBlank("authorizationCode", authorizationCode);
        return builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }


    @java.lang.SuppressWarnings("all")
    public static class AuthorizationCodeParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private String authorizationCode;
        @java.lang.SuppressWarnings("all")
        private URI redirectUri;
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private String codeVerifier;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        private String tenant;

        @java.lang.SuppressWarnings("all")
        AuthorizationCodeParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder authorizationCode(final String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder redirectUri(final URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder codeVerifier(final String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(authorizationCode, redirectUri, scopes, claims, codeVerifier, extraHttpHeaders, tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + ", claims=" + this.claims + ", codeVerifier=" + this.codeVerifier + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more

     * details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public String authorizationCode() {
        return this.authorizationCode;
    }

    /**
     * Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0

     * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public URI redirectUri() {
        return this.redirectUri;
    }

    /**
     * Scopes to which the application is requesting access
     */
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
     */
    @java.lang.SuppressWarnings("all")
    public String codeVerifier() {
        return this.codeVerifier;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    public String tenant() {
        return this.tenant;
    }

    @java.lang.SuppressWarnings("all")
    private AuthorizationCodeParameters(@NonNull final String authorizationCode, @NonNull final URI redirectUri, final Set<String> scopes, final ClaimsRequest claims, final String codeVerifier, final Map<String, String> extraHttpHeaders, final String tenant) {
        if (authorizationCode == null) {
            throw new java.lang.NullPointerException("authorizationCode is marked @NonNull but is null");
        }
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
        this.scopes = scopes;
        this.claims = claims;
        this.codeVerifier = codeVerifier;
        this.extraHttpHeaders = extraHttpHeaders;
        this.tenant = tenant;
    }
}
