// Generated by delombok at Mon Oct 31 16:54:22 UTC 2022
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for Integrated Windows Authentication. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(IntegratedWindowsAuthenticationParameters)}`

 * <p>

 * For more details, see https://aka.ms/msal4j-iwa
 */
public class IntegratedWindowsAuthenticationParameters implements IAcquireTokenParameters {
    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    private String username;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static IntegratedWindowsAuthenticationParametersBuilder builder() {
        return new IntegratedWindowsAuthenticationParametersBuilder();
    }

    /**
     * Builder for {@link IntegratedWindowsAuthenticationParameters}

     *

     * @param scopes   scopes application is requesting access to

     * @param username identifier of user account for which to acquire token for. Usually in UPN format,

     *                 e.g. john.doe@contoso.com.

     * @return builder that can be used to construct IntegratedWindowsAuthenticationParameters
     */
    public static IntegratedWindowsAuthenticationParametersBuilder builder(Set<String> scopes, String username) {
        validateNotNull("scopes", scopes);
        validateNotBlank("username", username);
        return builder().scopes(scopes).username(username);
    }


    @java.lang.SuppressWarnings("all")
    public static class IntegratedWindowsAuthenticationParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private String username;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        private String tenant;

        @java.lang.SuppressWarnings("all")
        IntegratedWindowsAuthenticationParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder username(final String username) {
            this.username = username;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public IntegratedWindowsAuthenticationParameters build() {
            return new IntegratedWindowsAuthenticationParameters(scopes, username, claims, extraHttpHeaders, tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public String username() {
        return this.username;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    public String tenant() {
        return this.tenant;
    }

    @java.lang.SuppressWarnings("all")
    private IntegratedWindowsAuthenticationParameters(@NonNull final Set<String> scopes, @NonNull final String username, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new java.lang.NullPointerException("username is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.username = username;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.tenant = tenant;
    }
}
