// Generated by delombok at Mon Oct 31 16:54:22 UTC 2022
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for silent requests. Can be used as parameter to

 * {@link PublicClientApplication#acquireTokenSilently(SilentParameters)} or to

 * {@link ConfidentialClientApplication#acquireTokenSilently(SilentParameters)}
 */
public class SilentParameters implements IAcquireTokenParameters {
    /**
     * Scopes application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Account for which you are requesting a token for.
     */
    private IAccount account;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
     */
    private ClaimsRequest claims;
    /**
     * Authority for which the application is requesting tokens from.
     */
    private String authorityUrl;
    /**
     * Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
     */
    private boolean forceRefresh;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    /**
     * Builder for SilentParameters

     *

     * @param scopes  scopes application is requesting access to

     * @param account {@link IAccount} for which to acquire a token for

     * @return builder object that can be used to construct SilentParameters
     */
    public static SilentParametersBuilder builder(Set<String> scopes, IAccount account) {
        validateNotNull("account", account);
        validateNotNull("scopes", scopes);
        return builder().scopes(removeEmptyScope(scopes)).account(account);
    }

    /**
     * Builder for SilentParameters

     *

     * @param scopes scopes application is requesting access to

     * @return builder object that can be used to construct SilentParameters

     * @deprecated This method was used for using cached tokens in client credentials or On-behalf-of

     * flow. Those flows will now by default attempt to use cached the cached tokens, so there is

     * no need to call acquireTokenSilently. This overload will be removed in the next major version.
     */
    @Deprecated
    public static SilentParametersBuilder builder(Set<String> scopes) {
        validateNotNull("scopes", scopes);
        return builder().scopes(removeEmptyScope(scopes));
    }

    private static Set<String> removeEmptyScope(Set<String> scopes) {
        // empty string is not a valid scope, but we currently accept it and can't remove support
        // for it yet as its a breaking change. This will be removed eventually (throwing
        // exception if empty scope is passed in).
        Set<String> updatedScopes = new HashSet<>();
        for (String scope : scopes) {
            if (!scope.equalsIgnoreCase(StringHelper.EMPTY_STRING)) {
                updatedScopes.add(scope.trim());
            }
        }
        return updatedScopes;
    }


    @java.lang.SuppressWarnings("all")
    public static class SilentParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private IAccount account;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private String authorityUrl;
        @java.lang.SuppressWarnings("all")
        private boolean forceRefresh;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        private String tenant;

        @java.lang.SuppressWarnings("all")
        SilentParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder account(final IAccount account) {
            this.account = account;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder authorityUrl(final String authorityUrl) {
            this.authorityUrl = authorityUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder forceRefresh(final boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public SilentParameters build() {
            return new SilentParameters(scopes, account, claims, authorityUrl, forceRefresh, extraHttpHeaders, tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", claims=" + this.claims + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ", extraHttpHeaders=" + this.extraHttpHeaders + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Account for which you are requesting a token for.
     */
    @java.lang.SuppressWarnings("all")
    public IAccount account() {
        return this.account;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Authority for which the application is requesting tokens from.
     */
    @java.lang.SuppressWarnings("all")
    public String authorityUrl() {
        return this.authorityUrl;
    }

    /**
     * Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
     */
    @java.lang.SuppressWarnings("all")
    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    public String tenant() {
        return this.tenant;
    }

    @java.lang.SuppressWarnings("all")
    private SilentParameters(@NonNull final Set<String> scopes, final IAccount account, final ClaimsRequest claims, final String authorityUrl, final boolean forceRefresh, final Map<String, String> extraHttpHeaders, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.account = account;
        this.claims = claims;
        this.authorityUrl = authorityUrl;
        this.forceRefresh = forceRefresh;
        this.extraHttpHeaders = extraHttpHeaders;
        this.tenant = tenant;
    }
}
