// Generated by delombok at Wed Jan 25 19:50:33 UTC 2023
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.net.InetSocketAddress;

class HttpListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpListener.class);
    private HttpServer server;
    private int port;

    void startListener(int port, HttpHandler httpHandler) {
        try {
            server = HttpServer.create(new InetSocketAddress(port), 0);
            server.createContext("/", httpHandler);
            this.port = server.getAddress().getPort();
            server.start();
            LOG.debug("Http listener started. Listening on port: " + port);
        } catch (Exception e) {
            throw new MsalClientException(e.getMessage(), AuthenticationErrorCode.UNABLE_TO_START_HTTP_LISTENER);
        }
    }

    void stopListener() {
        if (server != null) {
            server.stop(0);
            LOG.debug("Http listener stopped");
        }
    }

    @java.lang.SuppressWarnings("all")
    int port() {
        return this.port;
    }
}
