// Generated by delombok at Sun Jul 14 14:31:54 UTC 2024
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.NonNull;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for interactive requests. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(InteractiveRequestParameters)}.

 * <p>

 * For more details, see https://aka.ms/msal4j-interactive-request.
 */
public class InteractiveRequestParameters implements IAcquireTokenParameters {
    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.

     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no

     * port is specified, MSAL will find an open port. For more information, see

     * https://aka.ms/msal4j-interactive-request.
     */
    @NonNull
    private URI redirectUri;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Scopes that the application is requesting access to and the user will consent to.
     */
    private Set<String> scopes;
    /**
     * Indicate the type of user interaction that is required.
     */
    private Prompt prompt;
    /**
     * Can be used to pre-fill the username/email address field of the sign-in page for the user,

     * if you know the username/email address ahead of time. Often apps use this parameter during

     * re-authentication, having already extracted the username from a previous sign-in using the

     * preferred_username claim.
     */
    private String loginHint;
    /**
     * Provides a hint about the tenant or domain that the user should use to sign in. The value

     * of the domain hint is a registered domain for the tenant.
     */
    private String domainHint;
    /**
     * Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
     */
    private SystemBrowserOptions systemBrowserOptions;
    private String claimsChallenge;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;
    /**
     * The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,

     * unless overridden here with some other positive integer

     *

     * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
     */
    private int httpPollingTimeoutInSeconds;
    /**
     * If set to true, the authorization result will contain the authority for the user's home cloud, and this authority

     * will be used for the token request instead of the authority set in the application.
     */
    private boolean instanceAware;
    /**
     * The parent window handle used to open UI elements with the correct parent

     *

     *

     * For browser scenarios and Windows console applications, this value should not need to be set

     *

     * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set

     *

     * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
     */
    private long windowHandle;
    private PopParameters proofOfPossession;

    private static InteractiveRequestParametersBuilder builder() {
        return new InteractiveRequestParametersBuilder();
    }

    public static InteractiveRequestParametersBuilder builder(URI redirectUri) {
        validateNotNull("redirect_uri", redirectUri);
        return builder().redirectUri(redirectUri);
    }


    public static class InteractiveRequestParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private URI redirectUri;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private Prompt prompt;
        @java.lang.SuppressWarnings("all")
        private String loginHint;
        @java.lang.SuppressWarnings("all")
        private String domainHint;
        @java.lang.SuppressWarnings("all")
        private SystemBrowserOptions systemBrowserOptions;
        @java.lang.SuppressWarnings("all")
        private String claimsChallenge;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        private String tenant;
        @java.lang.SuppressWarnings("all")
        private boolean httpPollingTimeoutInSeconds$set;
        @java.lang.SuppressWarnings("all")
        private int httpPollingTimeoutInSeconds;
        @java.lang.SuppressWarnings("all")
        private boolean instanceAware;
        @java.lang.SuppressWarnings("all")
        private long windowHandle;
        @java.lang.SuppressWarnings("all")
        private PopParameters proofOfPossession;

        public InteractiveRequestParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uri, String nonce) {
            this.proofOfPossession = new PopParameters(httpMethod, uri, nonce);
            return this;
            //This Builder class is used to override Lombok's default setter behavior for any fields defined in it
            /**
         * Sets the PopParameters for this request, allowing the request to retrieve proof-of-possession tokens rather than bearer tokens
         *
         * For more information, see {@link PopParameters} and https://aka.ms/msal4j-pop
         *
         * @param httpMethod a valid HTTP method, such as "GET" or "POST"
         * @param uri the URI on the downstream protected API which the application is trying to access, e.g. https://graph.microsoft.com/beta/me/profile
         * @param nonce a string obtained by calling the resource (e.g. Microsoft Graph) un-authenticated and parsing the WWW-Authenticate header associated with pop authentication scheme and extracting the nonce parameter, or, on subsequent calls, by parsing the Autheticate-Info header and extracting the nextnonce parameter.
         */
        }

        @java.lang.SuppressWarnings("all")
        InteractiveRequestParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder redirectUri(final URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder prompt(final Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder loginHint(final String loginHint) {
            this.loginHint = loginHint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder domainHint(final String domainHint) {
            this.domainHint = domainHint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder systemBrowserOptions(final SystemBrowserOptions systemBrowserOptions) {
            this.systemBrowserOptions = systemBrowserOptions;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder claimsChallenge(final String claimsChallenge) {
            this.claimsChallenge = claimsChallenge;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder httpPollingTimeoutInSeconds(final int httpPollingTimeoutInSeconds) {
            this.httpPollingTimeoutInSeconds = httpPollingTimeoutInSeconds;
            httpPollingTimeoutInSeconds$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder instanceAware(final boolean instanceAware) {
            this.instanceAware = instanceAware;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParametersBuilder windowHandle(final long windowHandle) {
            this.windowHandle = windowHandle;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public InteractiveRequestParameters build() {
            int httpPollingTimeoutInSeconds = this.httpPollingTimeoutInSeconds;
            if (!httpPollingTimeoutInSeconds$set) httpPollingTimeoutInSeconds = InteractiveRequestParameters.$default$httpPollingTimeoutInSeconds();
            return new InteractiveRequestParameters(redirectUri, claims, scopes, prompt, loginHint, domainHint, systemBrowserOptions, claimsChallenge, extraHttpHeaders, extraQueryParameters, tenant, httpPollingTimeoutInSeconds, instanceAware, windowHandle, proofOfPossession);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "InteractiveRequestParameters.InteractiveRequestParametersBuilder(redirectUri=" + this.redirectUri + ", claims=" + this.claims + ", scopes=" + this.scopes + ", prompt=" + this.prompt + ", loginHint=" + this.loginHint + ", domainHint=" + this.domainHint + ", systemBrowserOptions=" + this.systemBrowserOptions + ", claimsChallenge=" + this.claimsChallenge + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", httpPollingTimeoutInSeconds=" + this.httpPollingTimeoutInSeconds + ", instanceAware=" + this.instanceAware + ", windowHandle=" + this.windowHandle + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    private static int $default$httpPollingTimeoutInSeconds() {
        return 120;
    }

    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.

     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no

     * port is specified, MSAL will find an open port. For more information, see

     * https://aka.ms/msal4j-interactive-request.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public URI redirectUri() {
        return this.redirectUri;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Scopes that the application is requesting access to and the user will consent to.
     */
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Indicate the type of user interaction that is required.
     */
    @java.lang.SuppressWarnings("all")
    public Prompt prompt() {
        return this.prompt;
    }

    /**
     * Can be used to pre-fill the username/email address field of the sign-in page for the user,

     * if you know the username/email address ahead of time. Often apps use this parameter during

     * re-authentication, having already extracted the username from a previous sign-in using the

     * preferred_username claim.
     */
    @java.lang.SuppressWarnings("all")
    public String loginHint() {
        return this.loginHint;
    }

    /**
     * Provides a hint about the tenant or domain that the user should use to sign in. The value

     * of the domain hint is a registered domain for the tenant.
     */
    @java.lang.SuppressWarnings("all")
    public String domainHint() {
        return this.domainHint;
    }

    /**
     * Sets {@link SystemBrowserOptions} to be used by the PublicClientApplication
     */
    @java.lang.SuppressWarnings("all")
    public SystemBrowserOptions systemBrowserOptions() {
        return this.systemBrowserOptions;
    }

    @java.lang.SuppressWarnings("all")
    public String claimsChallenge() {
        return this.claimsChallenge;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    public String tenant() {
        return this.tenant;
    }

    /**
     * The amount of time in seconds that the library will wait for an authentication result. 120 seconds is the default timeout,

     * unless overridden here with some other positive integer

     *

     * If this timeout is set to 0 or less it will be ignored, and the library will use a 1 second timeout instead
     */
    @java.lang.SuppressWarnings("all")
    public int httpPollingTimeoutInSeconds() {
        return this.httpPollingTimeoutInSeconds;
    }

    /**
     * If set to true, the authorization result will contain the authority for the user's home cloud, and this authority

     * will be used for the token request instead of the authority set in the application.
     */
    @java.lang.SuppressWarnings("all")
    public boolean instanceAware() {
        return this.instanceAware;
    }

    /**
     * The parent window handle used to open UI elements with the correct parent

     *

     *

     * For browser scenarios and Windows console applications, this value should not need to be set

     *

     * For Windows console applications, MSAL Java will attempt to discover the console's window handle if this parameter is not set

     *

     * For scenarios where MSAL Java is responsible for opening UI elements (such as when using MSALRuntime), this parameter is required and an exception will be thrown if not set
     */
    @java.lang.SuppressWarnings("all")
    public long windowHandle() {
        return this.windowHandle;
    }

    @java.lang.SuppressWarnings("all")
    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    @java.lang.SuppressWarnings("all")
    private InteractiveRequestParameters(@NonNull final URI redirectUri, final ClaimsRequest claims, final Set<String> scopes, final Prompt prompt, final String loginHint, final String domainHint, final SystemBrowserOptions systemBrowserOptions, final String claimsChallenge, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant, final int httpPollingTimeoutInSeconds, final boolean instanceAware, final long windowHandle, final PopParameters proofOfPossession) {
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.redirectUri = redirectUri;
        this.claims = claims;
        this.scopes = scopes;
        this.prompt = prompt;
        this.loginHint = loginHint;
        this.domainHint = domainHint;
        this.systemBrowserOptions = systemBrowserOptions;
        this.claimsChallenge = claimsChallenge;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
        this.httpPollingTimeoutInSeconds = httpPollingTimeoutInSeconds;
        this.instanceAware = instanceAware;
        this.windowHandle = windowHandle;
        this.proofOfPossession = proofOfPossession;
    }

    /**
     * Redirect URI where MSAL will listen to for the authorization code returned by Azure AD.

     * Should be a loopback address with a port specified (for example, http://localhost:3671). If no

     * port is specified, MSAL will find an open port. For more information, see

     * https://aka.ms/msal4j-interactive-request.
     * @return this
     */
    @java.lang.SuppressWarnings("all")
    InteractiveRequestParameters redirectUri(@NonNull final URI redirectUri) {
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.redirectUri = redirectUri;
        return this;
    }
}
