// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for Integrated Windows Authentication. Can be used as parameter to
 * {@link PublicClientApplication#acquireToken(IntegratedWindowsAuthenticationParameters)}`
 * <p>
 * For more details, see https://aka.ms/msal4j-iwa
 */
public class IntegratedWindowsAuthenticationParameters implements IAcquireTokenParameters {
    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    private String username;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static IntegratedWindowsAuthenticationParametersBuilder builder() {
        return new IntegratedWindowsAuthenticationParametersBuilder();
    }

    /**
     * Builder for {@link IntegratedWindowsAuthenticationParameters}
     *
     * @param scopes   scopes application is requesting access to
     * @param username identifier of user account for which to acquire token for. Usually in UPN format,
     *                 e.g. john.doe@contoso.com.
     * @return builder that can be used to construct IntegratedWindowsAuthenticationParameters
     */
    public static IntegratedWindowsAuthenticationParametersBuilder builder(Set<String> scopes, String username) {
        validateNotNull("scopes", scopes);
        validateNotBlank("username", username);
        return builder().scopes(scopes).username(username);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class IntegratedWindowsAuthenticationParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String username;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        IntegratedWindowsAuthenticationParametersBuilder() {
        }

        /**
         * Scopes that the application is requesting access to
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Identifier of user account for which to acquire tokens for
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder username(@NonNull final String username) {
            if (username == null) {
                throw new java.lang.NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IntegratedWindowsAuthenticationParameters build() {
            return new IntegratedWindowsAuthenticationParameters(this.scopes, this.username, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes that the application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Identifier of user account for which to acquire tokens for
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String username() {
        return this.username;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Creates a new {@code IntegratedWindowsAuthenticationParameters} instance.
     *
     * @param scopes Scopes that the application is requesting access to
     * @param username Identifier of user account for which to acquire tokens for
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private IntegratedWindowsAuthenticationParameters(@NonNull final Set<String> scopes, @NonNull final String username, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        if (username == null) {
            throw new java.lang.NullPointerException("username is marked non-null but is null");
        }
        this.scopes = scopes;
        this.username = username;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }
}
