// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.net.URI;

/**
 * Options for using the default OS browser as a separate process to handle interactive authentication.
 * MSAL will listen for the OS browser to finish authenticating, but it cannot close the browser.
 * It can however response with a HTTP 200 OK message or a 302 Redirect, which can be configured here.
 * For more details, see https://aka.ms/msal4j-interactive-request
 */
public class SystemBrowserOptions {
    /**
     * When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the
     * browser will show to the user
     */
    private String htmlMessageSuccess;
    /**
     * WHen the user finishes authenticating, but an error occurred, MSAL will respond with a
     * Http 200 Ok message, which the browser will show to the user.
     */
    private String htmlMessageError;
    /**
     * When the user finishes authenticating, MSAL will redirect the browser to the given URI.
     * Takes precedence over htmlMessageSuccess
     */
    private URI browserRedirectSuccess;
    /**
     * When the the user finishes authenticating, but an error occurred, MSAL will redirect the
     * browser to the given URI.
     * Takes precedence over htmlMessageError
     */
    private URI browserRedirectError;
    /**
     * Allows developers to implement their own logic for starting a browser and navigating to a
     * specific Uri. Msal will use this when opening the browser. If not set, the user configured
     * browser will be used.
     */
    private OpenBrowserAction openBrowserAction;

    /**
     * Builder for {@link SystemBrowserOptions}
     */
    public static SystemBrowserOptionsBuilder builder() {
        return new SystemBrowserOptionsBuilder();
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class SystemBrowserOptionsBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String htmlMessageSuccess;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String htmlMessageError;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private URI browserRedirectSuccess;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private URI browserRedirectError;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private OpenBrowserAction openBrowserAction;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        SystemBrowserOptionsBuilder() {
        }

        /**
         * When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the
         * browser will show to the user
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions.SystemBrowserOptionsBuilder htmlMessageSuccess(final String htmlMessageSuccess) {
            this.htmlMessageSuccess = htmlMessageSuccess;
            return this;
        }

        /**
         * WHen the user finishes authenticating, but an error occurred, MSAL will respond with a
         * Http 200 Ok message, which the browser will show to the user.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions.SystemBrowserOptionsBuilder htmlMessageError(final String htmlMessageError) {
            this.htmlMessageError = htmlMessageError;
            return this;
        }

        /**
         * When the user finishes authenticating, MSAL will redirect the browser to the given URI.
         * Takes precedence over htmlMessageSuccess
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions.SystemBrowserOptionsBuilder browserRedirectSuccess(final URI browserRedirectSuccess) {
            this.browserRedirectSuccess = browserRedirectSuccess;
            return this;
        }

        /**
         * When the the user finishes authenticating, but an error occurred, MSAL will redirect the
         * browser to the given URI.
         * Takes precedence over htmlMessageError
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions.SystemBrowserOptionsBuilder browserRedirectError(final URI browserRedirectError) {
            this.browserRedirectError = browserRedirectError;
            return this;
        }

        /**
         * Allows developers to implement their own logic for starting a browser and navigating to a
         * specific Uri. Msal will use this when opening the browser. If not set, the user configured
         * browser will be used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions.SystemBrowserOptionsBuilder openBrowserAction(final OpenBrowserAction openBrowserAction) {
            this.openBrowserAction = openBrowserAction;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SystemBrowserOptions build() {
            return new SystemBrowserOptions(this.htmlMessageSuccess, this.htmlMessageError, this.browserRedirectSuccess, this.browserRedirectError, this.openBrowserAction);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SystemBrowserOptions.SystemBrowserOptionsBuilder(htmlMessageSuccess=" + this.htmlMessageSuccess + ", htmlMessageError=" + this.htmlMessageError + ", browserRedirectSuccess=" + this.browserRedirectSuccess + ", browserRedirectError=" + this.browserRedirectError + ", openBrowserAction=" + this.openBrowserAction + ")";
        }
    }

    /**
     * When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the
     * browser will show to the user
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String htmlMessageSuccess() {
        return this.htmlMessageSuccess;
    }

    /**
     * WHen the user finishes authenticating, but an error occurred, MSAL will respond with a
     * Http 200 Ok message, which the browser will show to the user.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String htmlMessageError() {
        return this.htmlMessageError;
    }

    /**
     * When the user finishes authenticating, MSAL will redirect the browser to the given URI.
     * Takes precedence over htmlMessageSuccess
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URI browserRedirectSuccess() {
        return this.browserRedirectSuccess;
    }

    /**
     * When the the user finishes authenticating, but an error occurred, MSAL will redirect the
     * browser to the given URI.
     * Takes precedence over htmlMessageError
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URI browserRedirectError() {
        return this.browserRedirectError;
    }

    /**
     * Allows developers to implement their own logic for starting a browser and navigating to a
     * specific Uri. Msal will use this when opening the browser. If not set, the user configured
     * browser will be used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public OpenBrowserAction openBrowserAction() {
        return this.openBrowserAction;
    }

    /**
     * Creates a new {@code SystemBrowserOptions} instance.
     *
     * @param htmlMessageSuccess When the user finishes authenticating, MSAL will respond with a Http 200 OK message, which the
     * browser will show to the user
     * @param htmlMessageError WHen the user finishes authenticating, but an error occurred, MSAL will respond with a
     * Http 200 Ok message, which the browser will show to the user.
     * @param browserRedirectSuccess When the user finishes authenticating, MSAL will redirect the browser to the given URI.
     * Takes precedence over htmlMessageSuccess
     * @param browserRedirectError When the the user finishes authenticating, but an error occurred, MSAL will redirect the
     * browser to the given URI.
     * Takes precedence over htmlMessageError
     * @param openBrowserAction Allows developers to implement their own logic for starting a browser and navigating to a
     * specific Uri. Msal will use this when opening the browser. If not set, the user configured
     * browser will be used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private SystemBrowserOptions(final String htmlMessageSuccess, final String htmlMessageError, final URI browserRedirectSuccess, final URI browserRedirectError, final OpenBrowserAction openBrowserAction) {
        this.htmlMessageSuccess = htmlMessageSuccess;
        this.htmlMessageError = htmlMessageError;
        this.browserRedirectSuccess = browserRedirectSuccess;
        this.browserRedirectError = browserRedirectError;
        this.openBrowserAction = openBrowserAction;
    }
}
