// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;

/**
 * Object containing parameters for authorization code flow. Can be used as parameter to
 * {@link PublicClientApplication#acquireToken(AuthorizationCodeParameters)} or to
 * {@link ConfidentialClientApplication#acquireToken(AuthorizationCodeParameters)}
 */
public class AuthorizationCodeParameters implements IAcquireTokenParameters {
    /**
     * Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more
     * details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    private String authorizationCode;
    /**
     * Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0
     * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    private URI redirectUri;
    /**
     * Scopes to which the application is requesting access
     */
    private Set<String> scopes;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
     */
    private String codeVerifier;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    /**
     * Builder for {@link AuthorizationCodeParameters}
     *
     * @param authorizationCode code received from the service authorization endpoint
     * @param redirectUri       URI where authorization code was received
     * @return builder object that can be used to construct {@link AuthorizationCodeParameters}
     */
    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        validateNotBlank("authorizationCode", authorizationCode);
        return builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class AuthorizationCodeParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String authorizationCode;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private URI redirectUri;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String codeVerifier;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        AuthorizationCodeParametersBuilder() {
        }

        /**
         * Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more
         * details, see https://aka.ms/msal4j-authorization-code-flow
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder authorizationCode(@NonNull final String authorizationCode) {
            if (authorizationCode == null) {
                throw new java.lang.NullPointerException("authorizationCode is marked non-null but is null");
            }
            this.authorizationCode = authorizationCode;
            return this;
        }

        /**
         * Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0
         * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder redirectUri(@NonNull final URI redirectUri) {
            if (redirectUri == null) {
                throw new java.lang.NullPointerException("redirectUri is marked non-null but is null");
            }
            this.redirectUri = redirectUri;
            return this;
        }

        /**
         * Scopes to which the application is requesting access
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder codeVerifier(final String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional query parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters.AuthorizationCodeParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(this.authorizationCode, this.redirectUri, this.scopes, this.claims, this.codeVerifier, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + ", claims=" + this.claims + ", codeVerifier=" + this.codeVerifier + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more
     * details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String authorizationCode() {
        return this.authorizationCode;
    }

    /**
     * Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0
     * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URI redirectUri() {
        return this.redirectUri;
    }

    /**
     * Scopes to which the application is requesting access
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String codeVerifier() {
        return this.codeVerifier;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Creates a new {@code AuthorizationCodeParameters} instance.
     *
     * @param authorizationCode Authorization code acquired in the first step of OAuth2.0 authorization code flow. For more
     * details, see https://aka.ms/msal4j-authorization-code-flow
     * @param redirectUri Redirect URI registered in the Azure portal, and which was used in the first step of OAuth2.0
     * authorization code flow. For more details, see https://aka.ms/msal4j-authorization-code-flow
     * @param scopes Scopes to which the application is requesting access
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param codeVerifier Code verifier used for PKCE. For more details, see https://tools.ietf.org/html/rfc7636
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional query parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private AuthorizationCodeParameters(@NonNull final String authorizationCode, @NonNull final URI redirectUri, final Set<String> scopes, final ClaimsRequest claims, final String codeVerifier, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant) {
        if (authorizationCode == null) {
            throw new java.lang.NullPointerException("authorizationCode is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new java.lang.NullPointerException("redirectUri is marked non-null but is null");
        }
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
        this.scopes = scopes;
        this.claims = claims;
        this.codeVerifier = codeVerifier;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }
}
