// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for refresh token request. Can be used as parameter to
 * {@link PublicClientApplication#acquireToken(RefreshTokenParameters)} or to
 * {@link ConfidentialClientApplication#acquireToken(RefreshTokenParameters)}
 * <p>
 * RefreshTokenParameters should only be used for migration scenarios (when moving from ADAL to
 * MSAL). To acquire tokens silently, use {@link AbstractClientApplicationBase#acquireTokenSilently(SilentParameters)}
 */
public class RefreshTokenParameters implements IAcquireTokenParameters {
    /**
     * Scopes the application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Refresh token received from the STS
     */
    @NonNull
    private String refreshToken;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static RefreshTokenParametersBuilder builder() {
        return new RefreshTokenParametersBuilder();
    }

    /**
     * Builder for {@link RefreshTokenParameters}
     *
     * @param scopes       scopes application is requesting access to
     * @param refreshToken refresh token received form the STS
     * @return builder object that can be used to construct {@link RefreshTokenParameters}
     */
    public static RefreshTokenParametersBuilder builder(Set<String> scopes, String refreshToken) {
        validateNotBlank("refreshToken", refreshToken);
        return builder().scopes(scopes).refreshToken(refreshToken);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class RefreshTokenParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String refreshToken;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        RefreshTokenParametersBuilder() {
        }

        /**
         * Scopes the application is requesting access to
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Refresh token received from the STS
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder refreshToken(@NonNull final String refreshToken) {
            if (refreshToken == null) {
                throw new java.lang.NullPointerException("refreshToken is marked non-null but is null");
            }
            this.refreshToken = refreshToken;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters.RefreshTokenParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RefreshTokenParameters build() {
            return new RefreshTokenParameters(this.scopes, this.refreshToken, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RefreshTokenParameters.RefreshTokenParametersBuilder(scopes=" + this.scopes + ", refreshToken=" + this.refreshToken + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes the application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Refresh token received from the STS
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String refreshToken() {
        return this.refreshToken;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Creates a new {@code RefreshTokenParameters} instance.
     *
     * @param scopes Scopes the application is requesting access to
     * @param refreshToken Refresh token received from the STS
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private RefreshTokenParameters(@NonNull final Set<String> scopes, @NonNull final String refreshToken, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new java.lang.NullPointerException("refreshToken is marked non-null but is null");
        }
        this.scopes = scopes;
        this.refreshToken = refreshToken;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }
}
