// Generated by delombok at Thu Feb 27 18:19:39 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.util.UUID;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IAcquireTokenParameters apiParameters;
    private IApplicationBase clientApplication;
    private UserIdentifier userIdentifier;

    public RequestContext(AbstractApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters) {
        this.clientApplication = clientApplication;
        this.clientId = StringHelper.isBlank(clientApplication.clientId()) ? "unset_client_id" : clientApplication.clientId();
        this.correlationId = StringHelper.isBlank(clientApplication.correlationId()) ? generateNewCorrelationId() : clientApplication.correlationId();
        if (clientApplication instanceof AbstractClientApplicationBase) {
            this.applicationVersion = ((AbstractClientApplicationBase) clientApplication).applicationVersion();
            this.applicationName = ((AbstractClientApplicationBase) clientApplication).applicationName();
        }
        this.publicApi = publicApi;
        this.authority = clientApplication.authority();
        this.apiParameters = apiParameters;
    }

    public RequestContext(AbstractApplicationBase clientApplication, PublicApi publicApi, IAcquireTokenParameters apiParameters, UserIdentifier userIdentifier) {
        this(clientApplication, publicApi, apiParameters);
        this.userIdentifier = userIdentifier;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String clientId() {
        return this.clientId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String correlationId() {
        return this.correlationId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    PublicApi publicApi() {
        return this.publicApi;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String applicationName() {
        return this.applicationName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String applicationVersion() {
        return this.applicationVersion;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    String authority() {
        return this.authority;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    IAcquireTokenParameters apiParameters() {
        return this.apiParameters;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    IApplicationBase clientApplication() {
        return this.clientApplication;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    RequestContext telemetryRequestId(final String telemetryRequestId) {
        this.telemetryRequestId = telemetryRequestId;
        return this;
    }
}
