// Generated by delombok at Fri Dec 11 23:49:21 UTC 2020
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for client credential flow. Can be used as parameter to

 * {@link ConfidentialClientApplication#acquireToken(ClientCredentialParameters)}
 */
public class ClientCredentialParameters implements IApiParameters {
    /**
     * Scopes for which the application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    /**
     * Builder for {@link ClientCredentialParameters}

     * @param scopes scopes application is requesting access to

     * @return builder that can be used to construct ClientCredentialParameters
     */
    public static ClientCredentialParametersBuilder builder(Set<String> scopes) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes);
    }


    @java.lang.SuppressWarnings("all")
    public static class ClientCredentialParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;

        @java.lang.SuppressWarnings("all")
        ClientCredentialParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public ClientCredentialParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public ClientCredentialParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public ClientCredentialParameters build() {
            return new ClientCredentialParameters(scopes, claims);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ")";
        }
    }

    /**
     * Scopes for which the application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    @java.lang.SuppressWarnings("all")
    private ClientCredentialParameters(@NonNull final Set<String> scopes, final ClaimsRequest claims) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
    }
}
