/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class ClientCredentialParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    private ClaimsRequest claims;

    private static ClientCredentialParametersBuilder builder() {
        return new ClientCredentialParametersBuilder();
    }

    public static ClientCredentialParametersBuilder builder(Set<String> scopes) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return ClientCredentialParameters.builder().scopes(scopes);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    private ClientCredentialParameters(@NonNull Set<String> scopes, ClaimsRequest claims) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
    }

    public static class ClientCredentialParametersBuilder {
        private Set<String> scopes;
        private ClaimsRequest claims;

        ClientCredentialParametersBuilder() {
        }

        public ClientCredentialParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public ClientCredentialParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        public ClientCredentialParameters build() {
            return new ClientCredentialParameters(this.scopes, this.claims);
        }

        public String toString() {
            return "ClientCredentialParameters.ClientCredentialParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ")";
        }
    }
}

