/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Registration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdmNativeRegistration
extends Registration {
    private static final String ADM_NATIVE_REGISTRATION_CUSTOM_NODE = "AdmRegistrationDescription";
    static final String ADM_HANDLE_NODE = "AdmRegistrationId";

    AdmNativeRegistration(String notificationHubPath) {
        super(notificationHubPath);
        this.mRegistrationType = Registration.RegistrationType.adm;
    }

    @Override
    protected String getSpecificPayloadNodeName() {
        return ADM_NATIVE_REGISTRATION_CUSTOM_NODE;
    }

    @Override
    protected void appendCustomPayload(Document doc, Element registrationDescription) {
        this.appendNodeWithValue(doc, registrationDescription, ADM_HANDLE_NODE, this.getPNSHandle());
    }

    @Override
    protected void loadCustomXmlData(Element payloadNode) {
        this.setPNSHandle(AdmNativeRegistration.getNodeValue(payloadNode, ADM_HANDLE_NODE));
        this.setName("$Default");
    }
}

