/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import com.microsoft.windowsazure.messaging.Registration;
import com.microsoft.windowsazure.messaging.TemplateRegistration;
import com.microsoft.windowsazure.messaging.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaiduTemplateRegistration
extends TemplateRegistration {
    protected String mUserId;
    protected String mChannelId;
    static final String BAIDU_TEMPLATE_REGISTRATION_CUSTOM_NODE = "BaiduTemplateRegistrationDescription";
    private static final String BAIDU_USER_ID = "BaiduUserId";
    private static final String BAIDU_CHANNEL_ID = "BaiduChannelId";
    private static final String BAIDU_HANDLE_NODE = "BaiduUserId-BaiduChannelId";

    BaiduTemplateRegistration(String notificationHubPath) {
        super(notificationHubPath);
        this.mRegistrationType = Registration.RegistrationType.baidu;
    }

    public String getUserId() {
        return this.mUserId;
    }

    void setUserId(String pUserId) {
        this.mUserId = pUserId;
    }

    public String getChannelId() {
        return this.mChannelId;
    }

    void setChannelId(String pChannelId) {
        this.mChannelId = pChannelId;
    }

    @Override
    void setPNSHandle(String pNSHandle) {
        if (Utils.isNullOrWhiteSpace(pNSHandle)) {
            return;
        }
        this.mPNSHandle = pNSHandle;
        String[] baiduInfo = pNSHandle.split("-");
        String userId = baiduInfo[0];
        if (Utils.isNullOrWhiteSpace(userId)) {
            throw new AssertionError((Object)"Baidu userId is inalid!");
        }
        this.setUserId(userId);
        String channelId = baiduInfo[1];
        if (Utils.isNullOrWhiteSpace(userId)) {
            throw new AssertionError((Object)"Baidu channelId is inalid!");
        }
        this.setChannelId(channelId);
    }

    @Override
    protected String getSpecificPayloadNodeName() {
        return BAIDU_TEMPLATE_REGISTRATION_CUSTOM_NODE;
    }

    @Override
    protected void appendCustomPayload(Document doc, Element templateRegistrationDescription) {
        this.appendNodeWithValue(doc, templateRegistrationDescription, BAIDU_USER_ID, this.getUserId());
        this.appendNodeWithValue(doc, templateRegistrationDescription, BAIDU_CHANNEL_ID, this.getChannelId());
        super.appendCustomPayload(doc, templateRegistrationDescription);
    }

    @Override
    protected void loadCustomXmlData(Element payloadNode) {
        this.setPNSHandle(BaiduTemplateRegistration.getNodeValue(payloadNode, BAIDU_HANDLE_NODE));
        super.loadCustomXmlData(payloadNode);
    }
}

