/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.messaging;

import android.os.Build;
import com.microsoft.windowsazure.messaging.AdmNativeRegistration;
import com.microsoft.windowsazure.messaging.AdmTemplateRegistration;
import com.microsoft.windowsazure.messaging.BaiduNativeRegistration;
import com.microsoft.windowsazure.messaging.BaiduTemplateRegistration;
import com.microsoft.windowsazure.messaging.FcmNativeRegistration;
import com.microsoft.windowsazure.messaging.FcmTemplateRegistration;
import com.microsoft.windowsazure.messaging.GcmNativeRegistration;
import com.microsoft.windowsazure.messaging.GcmTemplateRegistration;
import com.microsoft.windowsazure.messaging.Registration;
import com.microsoft.windowsazure.messaging.TemplateRegistration;

public final class PnsSpecificRegistrationFactory {
    private static Registration.RegistrationType mRegistrationType = Registration.RegistrationType.fcm;
    private static final PnsSpecificRegistrationFactory mInstance = new PnsSpecificRegistrationFactory();

    private PnsSpecificRegistrationFactory() {
        boolean isAmazondevice;
        boolean bl = isAmazondevice = Build.MANUFACTURER.compareToIgnoreCase("Amazon") == 0;
        if (isAmazondevice) {
            mRegistrationType = Registration.RegistrationType.adm;
        }
    }

    public static PnsSpecificRegistrationFactory getInstance() {
        return mInstance;
    }

    public void setRegistrationType(Registration.RegistrationType type) {
        mRegistrationType = type;
    }

    public Registration createNativeRegistration(String notificationHubPath) {
        switch (mRegistrationType) {
            case gcm: {
                return new GcmNativeRegistration(notificationHubPath);
            }
            case fcm: {
                return new FcmNativeRegistration(notificationHubPath);
            }
            case baidu: {
                return new BaiduNativeRegistration(notificationHubPath);
            }
            case adm: {
                return new AdmNativeRegistration(notificationHubPath);
            }
        }
        throw new AssertionError((Object)"Ivalid registration type!");
    }

    public TemplateRegistration createTemplateRegistration(String notificationHubPath) {
        switch (mRegistrationType) {
            case gcm: {
                return new GcmTemplateRegistration(notificationHubPath);
            }
            case fcm: {
                return new FcmTemplateRegistration(notificationHubPath);
            }
            case baidu: {
                return new BaiduTemplateRegistration(notificationHubPath);
            }
            case adm: {
                return new AdmTemplateRegistration(notificationHubPath);
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }

    public boolean isTemplateRegistration(String xml) {
        String tempelateRegistrationCustomNode;
        switch (mRegistrationType) {
            case gcm: {
                tempelateRegistrationCustomNode = "GcmTemplateRegistrationDescription";
                break;
            }
            case fcm: {
                tempelateRegistrationCustomNode = "GcmTemplateRegistrationDescription";
                break;
            }
            case baidu: {
                tempelateRegistrationCustomNode = "BaiduTemplateRegistrationDescription";
                break;
            }
            case adm: {
                tempelateRegistrationCustomNode = "AdmTemplateRegistrationDescription";
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid registration type!");
            }
        }
        return xml.contains("<" + tempelateRegistrationCustomNode);
    }

    public String getPNSHandleFieldName() {
        switch (mRegistrationType) {
            case gcm: {
                return "GcmRegistrationId";
            }
            case fcm: {
                return "GcmRegistrationId";
            }
            case baidu: {
                return "BaiduUserId-BaiduChannelId";
            }
            case adm: {
                return "AdmRegistrationId";
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }

    public String getAPIOrigin() {
        switch (mRegistrationType) {
            case gcm: {
                return "AndroidSdkGcm";
            }
            case fcm: {
                return "AndroidSdkFcm";
            }
            case baidu: {
                return "AndroidSdkBaidu";
            }
            case adm: {
                return "AndroidSdkAdm";
            }
        }
        throw new AssertionError((Object)"Invalid registration type!");
    }
}

