/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;

public class ProxyAuthenticator {
    public PasswordAuthentication getPasswordAuthentication(String scheme, String host) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        List<Proxy> proxies = null;
        if (host != null && !host.isEmpty()) {
            URI uri = URI.create(host);
            proxies = proxySelector.select(uri);
        }
        InetAddress proxyAddr = null;
        Enum proxyType = null;
        if (this.isProxyAddressLegal(proxies)) {
            proxyAddr = ((InetSocketAddress)proxies.get(0).address()).getAddress();
            proxyType = proxies.get(0).type();
        }
        return Authenticator.requestPasswordAuthentication("", proxyAddr, 0, proxyType == null ? "" : proxyType.name(), "Event Hubs client websocket proxy support", scheme, null, Authenticator.RequestorType.PROXY);
    }

    public boolean isPasswordAuthenticationHasValues(PasswordAuthentication passwordAuthentication) {
        String proxyPassword;
        if (passwordAuthentication == null) {
            return false;
        }
        String proxyUserName = passwordAuthentication.getUserName() != null ? passwordAuthentication.getUserName() : null;
        String string = proxyPassword = passwordAuthentication.getPassword() != null ? new String(passwordAuthentication.getPassword()) : null;
        return !this.isNullOrEmpty(proxyUserName) && !this.isNullOrEmpty(proxyPassword);
    }

    private boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

