/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.amqp;

import com.microsoft.azure.sdk.iot.deps.transport.amqp.AmqpDeviceOperations;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.AmqpListener;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.AmqpMessage;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.AmqpReactor;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.ErrorLoggingBaseHandlerWithCleanup;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.SaslHandler;
import com.microsoft.azure.sdk.iot.deps.transport.amqp.SaslListenerImpl;
import com.microsoft.azure.sdk.iot.deps.util.ObjectLock;
import com.microsoft.azure.sdk.iot.deps.ws.impl.WebSocketImpl;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.reactor.FlowController;
import org.apache.qpid.proton.reactor.Handshaker;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpsConnection
extends ErrorLoggingBaseHandlerWithCleanup {
    private static final Logger log = LoggerFactory.getLogger(AmqpsConnection.class);
    private static final int MAX_WAIT_TO_OPEN_CLOSE_CONNECTION = 60000;
    private static final int MAX_WAIT_TO_TERMINATE_EXECUTOR = 30;
    private static final String WEB_SOCKET_PATH = "/$iothub/websocket";
    private static final String WEB_SOCKET_SUB_PROTOCOL = "AMQPWSB10";
    private static final int AMQP_PORT = 5671;
    private static final int AMQP_WEB_SOCKET_PORT = 443;
    private static final int THREAD_POOL_MAX_NUMBER = 1;
    private int linkCredit;
    private long nextTag;
    private final Boolean useWebSockets;
    private Boolean isOpen;
    private final String hostName;
    private final String fullHostAddress;
    private Connection connection;
    private Session session;
    private ExecutorService executorService;
    private final AmqpDeviceOperations amqpDeviceOperations;
    private Reactor reactor;
    private SaslListenerImpl saslListener;
    private AmqpListener msgListener;
    private CountDownLatch openLatch;
    private final ObjectLock closeLock;
    private final SSLContext sslContext;

    public AmqpsConnection(String hostName, AmqpDeviceOperations amqpDeviceOperations, SSLContext sslContext, SaslHandler saslHandler, boolean useWebSockets) throws IOException {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("The hostname cannot be null or empty.");
        }
        this.linkCredit = -1;
        this.nextTag = 0L;
        this.amqpDeviceOperations = amqpDeviceOperations;
        this.useWebSockets = useWebSockets;
        if (saslHandler != null) {
            this.saslListener = new SaslListenerImpl(saslHandler);
        }
        this.openLatch = new CountDownLatch(1);
        this.closeLock = new ObjectLock();
        this.sslContext = sslContext;
        this.isOpen = false;
        this.fullHostAddress = String.format("%s:%d", hostName, this.useWebSockets != false ? 443 : 5671);
        this.hostName = hostName;
        this.add((Handler)new Handshaker());
        this.add((Handler)new FlowController());
        ReactorOptions options = new ReactorOptions();
        options.setEnableSaslByDefault(false);
        this.reactor = Proton.reactor((ReactorOptions)options, (Handler[])new Handler[]{this});
    }

    public void setListener(AmqpListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null.");
        }
        this.msgListener = listener;
    }

    public boolean isConnected() throws Exception {
        if (this.saslListener != null && this.saslListener.getSavedException() != null) {
            throw this.saslListener.getSavedException();
        }
        if (this.protonJExceptionParser != null && this.protonJExceptionParser.getError() != null) {
            throw new IOException("Encountered exception during amqp connection: " + this.protonJExceptionParser.getError() + " with description " + this.protonJExceptionParser.getErrorDescription());
        }
        return this.isOpen;
    }

    public void open() throws IOException {
        if (!this.isOpen.booleanValue()) {
            try {
                log.debug("Opening amqp connection asynchronously");
                this.openAmqpAsync();
            }
            catch (Exception e) {
                String errorMessage = "Error opening Amqp connection: ";
                log.error(errorMessage, (Throwable)e);
                this.close();
                throw new IOException(errorMessage, e);
            }
            try {
                this.openLatch.await(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                String errorMessage = "Amqp connection was interrupted while opening.";
                log.error(errorMessage, (Throwable)e);
                this.close();
                throw new IOException(errorMessage, e);
            }
        }
        log.trace("Open called while amqp connection was already open");
        if (!this.isOpen.booleanValue()) {
            throw new IOException("Timed out  to open the amqp connection");
        }
    }

    public void openAmqpAsync() {
        this.openLatch = new CountDownLatch(1);
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(1);
        }
        log.debug("Starting amqp reactor thread...");
        AmqpReactor amqpReactor = new AmqpReactor(this.reactor);
        ReactorRunner reactorRunner = new ReactorRunner(amqpReactor);
        this.executorService.submit(reactorRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isOpen.booleanValue()) {
            log.debug("Closing amqp connection");
            this.amqpDeviceOperations.closeLinks();
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.reactor != null) {
                this.reactor.stop();
            }
            try {
                ObjectLock objectLock = this.closeLock;
                synchronized (objectLock) {
                    this.closeLock.waitLock(60000L);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Waited too long for the connection to close.", e);
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.executorService.shutdownNow();
                        if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                            log.info("Pool did not terminate");
                        }
                    }
                }
                catch (InterruptedException ie) {
                    this.executorService.shutdownNow();
                }
            }
            this.isOpen = false;
        }
    }

    public void onReactorInit(Event event) {
        event.getReactor().connectionToHost(this.hostName, this.useWebSockets != false ? 443 : 5671, (Handler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReactorFinal(Event event) {
        super.onReactorFinal(event);
        this.reactor = null;
        ObjectLock objectLock = this.closeLock;
        synchronized (objectLock) {
            this.closeLock.notifyLock();
        }
    }

    public void onConnectionInit(Event event) {
        this.connection = event.getConnection();
        this.connection.setHostname(this.fullHostAddress);
        this.session = this.connection.session();
        this.connection.open();
        this.session.open();
        this.amqpDeviceOperations.openLinks(this.session);
    }

    private SslDomain makeDomain() {
        SslDomain domain = Proton.sslDomain();
        domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
        domain.init(SslDomain.Mode.CLIENT);
        domain.setSslContext(this.sslContext);
        return domain;
    }

    public void onConnectionBound(Event event) {
        Transport transport = event.getConnection().getTransport();
        if (transport != null) {
            if (this.saslListener != null) {
                log.debug("Setting up sasl negotiator");
                transport.sasl().setListener((SaslListener)this.saslListener);
            }
            if (this.useWebSockets.booleanValue()) {
                log.debug("Adding websocket layer");
                WebSocketImpl webSocket = new WebSocketImpl();
                webSocket.configure(this.hostName, WEB_SOCKET_PATH, 0, WEB_SOCKET_SUB_PROTOCOL, null, null);
                ((TransportInternal)transport).addTransportLayer((TransportLayer)webSocket);
            }
            SslDomain domain = this.makeDomain();
            transport.ssl(domain);
        }
    }

    public void onConnectionUnbound(Event event) {
        log.trace("Amqp connection unbound");
        this.isOpen = false;
    }

    public void onLinkInit(Event event) {
        Link link = event.getLink();
        this.amqpDeviceOperations.initLink(link);
    }

    @Override
    public void onLinkRemoteOpen(Event event) {
        super.onLinkRemoteOpen(event);
        String linkName = event.getLink().getName();
        if (this.amqpDeviceOperations.isReceiverLinkTag(linkName)) {
            this.isOpen = true;
            if (this.msgListener != null) {
                this.openLatch.countDown();
            }
        }
    }

    public boolean sendAmqpMessage(AmqpMessage message) throws Exception {
        if (!this.isConnected()) {
            return false;
        }
        byte[] msgData = new byte[1024];
        int length = 0;
        boolean encodingComplete = false;
        do {
            try {
                length = message.encode(msgData, 0);
                encodingComplete = true;
            }
            catch (BufferOverflowException e) {
                msgData = new byte[msgData.length * 2];
            }
        } while (!encodingComplete);
        if (length > 0) {
            byte[] tag = String.valueOf(this.nextTag).getBytes();
            this.nextTag = this.nextTag == Integer.MAX_VALUE || this.nextTag < 0L ? 0L : ++this.nextTag;
            this.amqpDeviceOperations.sendMessage(tag, msgData, length, 0);
            return true;
        }
        return false;
    }

    public void onDelivery(Event event) {
        Link link = event.getLink();
        if (link instanceof Sender) {
            Delivery d = event.getDelivery();
            DeliveryState remoteState = d.getRemoteState();
            boolean messageAcknowledgedAsSuccess = remoteState.equals(Accepted.getInstance());
            if (!messageAcknowledgedAsSuccess) {
                String error = "Amqp message was not accepted by service, remote state was " + remoteState.getType();
                this.msgListener.messageSendFailed(error);
            }
            d.free();
        } else if (link instanceof Receiver) {
            AmqpMessage message = this.amqpDeviceOperations.receiverMessageFromLink(event.getLink().getName());
            if (message != null) {
                log.debug("Amqp connection received message");
                this.msgListener.messageReceived(message);
            } else {
                log.warn("onDelivery executed on a receiver link but no message could be received");
            }
        } else {
            log.warn("onDelivery executed on a link that is neither a sender or a receiver");
        }
    }

    public void onLinkFlow(Event event) {
        this.linkCredit = event.getLink().getCredit();
        log.trace("Amqp link received {} link credit", (Object)this.linkCredit);
    }

    @Override
    public void onTransportError(Event event) {
        super.onTransportError(event);
        this.isOpen = false;
    }

    public void onTransportHeadClosed(Event event) {
        this.openLatch.countDown();
        log.trace("Amqp transport head closed");
    }

    private static class ReactorRunner
    implements Callable<Object> {
        private static final String THREAD_NAME = "azure-iot-sdk-ReactorRunner";
        private final AmqpReactor amqpReactor;

        ReactorRunner(AmqpReactor reactor) {
            this.amqpReactor = reactor;
        }

        @Override
        public Object call() {
            Thread.currentThread().setName(THREAD_NAME);
            log.trace("Amqp reactor thread {} has started", (Object)THREAD_NAME);
            try {
                this.amqpReactor.run();
            }
            catch (HandlerException e) {
                log.error("Encountered an exception while running the AMQP reactor", (Throwable)e);
                throw e;
            }
            log.trace("Amqp reactor thread {} has finished", (Object)THREAD_NAME);
            return null;
        }
    }
}

