/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.amqp;

import com.microsoft.azure.sdk.iot.deps.transport.amqp.ErrorLoggingBaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLoggingBaseHandlerWithCleanup
extends ErrorLoggingBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorLoggingBaseHandlerWithCleanup.class);

    @Override
    public void onLinkRemoteClose(Event event) {
        super.onLinkRemoteClose(event);
        if (event.getLink().getLocalState() == EndpointState.ACTIVE) {
            log.debug("Closing amqp link locally since amqp link was closed remotely");
            event.getLink().close();
        }
    }

    @Override
    public void onSessionRemoteClose(Event event) {
        super.onSessionRemoteClose(event);
        if (event.getSession().getLocalState() == EndpointState.ACTIVE) {
            log.debug("Closing amqp session locally since amqp session was closed remotely");
            event.getSession().close();
        }
    }

    @Override
    public void onConnectionRemoteClose(Event event) {
        super.onConnectionRemoteClose(event);
        if (event.getConnection().getLocalState() == EndpointState.CLOSED) {
            log.trace("Stopping reactor now that connection is closed locally and remotely");
            event.getReactor().stop();
        } else {
            log.debug("Closing amqp connection locally since amqp connection was closed remotely");
            event.getConnection().close();
        }
    }

    @Override
    public void onTransportError(Event event) {
        super.onTransportError(event);
        if (event.getConnection() != null) {
            log.debug("Closing amqp connection locally since amqp transport error was thrown");
            event.getConnection().close();
        }
    }

    public void onLinkRemoteOpen(Event event) {
        super.onLinkRemoteOpen(event);
        log.debug("Amqp Link with name {} opened remotely", (Object)event.getLink().getName());
    }

    public void onConnectionRemoteOpen(Event event) {
        super.onConnectionRemoteOpen(event);
        log.debug("Amqp Connection opened remotely");
    }

    public void onSessionRemoteOpen(Event event) {
        super.onSessionRemoteOpen(event);
        log.debug("Amqp Session opened remotely");
    }

    public void onLinkLocalOpen(Event event) {
        super.onLinkLocalOpen(event);
        log.trace("Amqp Link with name {} opened locally", (Object)event.getLink().getName());
    }

    public void onConnectionLocalOpen(Event event) {
        super.onConnectionLocalOpen(event);
        log.trace("Amqp Connection opened locally");
    }

    public void onSessionLocalOpen(Event event) {
        super.onSessionLocalOpen(event);
        log.trace("Amqp Session opened locally");
    }

    public void onLinkLocalClose(Event event) {
        super.onLinkLocalClose(event);
        log.debug("Closing amqp session locally since amqp link was closed locally");
        event.getSession().close();
    }

    public void onSessionLocalClose(Event event) {
        super.onSessionLocalClose(event);
        log.debug("Closing amqp connection locally since amqp session was closed locally");
        event.getConnection().close();
    }

    public void onConnectionLocalClose(Event event) {
        super.onConnectionLocalClose(event);
        if (event.getConnection().getRemoteState() == EndpointState.CLOSED) {
            log.trace("Stopping reactor now that amqp connection is closed locally and remotely");
            event.getReactor().stop();
        }
    }
}

