/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.ws.impl;

import com.microsoft.azure.sdk.iot.deps.ws.WebSocket;
import com.microsoft.azure.sdk.iot.deps.ws.WebSocketHandler;
import com.microsoft.azure.sdk.iot.deps.ws.impl.WebSocketHandlerImpl;
import com.microsoft.azure.sdk.iot.deps.ws.impl.WebSocketSniffer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.PlainTransportWrapper;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class WebSocketImpl
implements WebSocket,
TransportLayer {
    private boolean _tail_closed = false;
    private final ByteBuffer _inputBuffer;
    private boolean _head_closed = false;
    private final ByteBuffer _outputBuffer;
    private final ByteBuffer _pingBuffer;
    private final ByteBuffer _wsInputBuffer;
    private final ByteBuffer _temp;
    private int _underlyingOutputSize = 0;
    private int _webSocketHeaderSize = 0;
    private WebSocketHandler _webSocketHandler;
    private WebSocket.WebSocketState _state = WebSocket.WebSocketState.PN_WS_NOT_STARTED;
    private String _host = "";
    private String _path = "";
    private int _port = 0;
    private String _protocol = "";
    private Map<String, String> _additionalHeaders = null;
    protected Boolean _isWebSocketEnabled;
    private WebSocketHandler.WebSocketMessageType _lastType;
    private long _lastLength;
    private long _bytesRead = 0L;
    private final int _dataStart = 0;
    private WebSocket.WebSocketFrameReadState _frameReadState = WebSocket.WebSocketFrameReadState.INIT_READ;

    public WebSocketImpl() {
        int _maxFrameSize = 4224;
        this._inputBuffer = ByteBufferUtils.newWriteableBuffer((int)_maxFrameSize);
        this._outputBuffer = ByteBufferUtils.newWriteableBuffer((int)_maxFrameSize);
        this._pingBuffer = ByteBufferUtils.newWriteableBuffer((int)_maxFrameSize);
        this._wsInputBuffer = ByteBufferUtils.newWriteableBuffer((int)_maxFrameSize);
        this._temp = ByteBufferUtils.newWriteableBuffer((int)_maxFrameSize);
        this._lastType = WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN;
        this._lastLength = 0L;
        this._isWebSocketEnabled = false;
    }

    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new WebSocketSniffer(new WebSocketTransportWrapper(input, output), (TransportWrapper)new PlainTransportWrapper(output, input)){

            protected boolean isDeterminationMade() {
                this._selectedTransportWrapper = this._wrapper1;
                return true;
            }
        };
    }

    @Override
    public void configure(String host, String path, int port, String protocol, Map<String, String> additionalHeaders, WebSocketHandler webSocketHandler) {
        this._host = host;
        this._path = path;
        this._port = port;
        this._protocol = protocol;
        this._additionalHeaders = additionalHeaders;
        this._webSocketHandler = webSocketHandler != null ? webSocketHandler : new WebSocketHandlerImpl();
        this._isWebSocketEnabled = true;
    }

    @Override
    public void wrapBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer) {
        if (this._isWebSocketEnabled.booleanValue()) {
            this._webSocketHandler.wrapBuffer(srcBuffer, dstBuffer);
        } else {
            dstBuffer.clear();
            dstBuffer.put(srcBuffer);
        }
    }

    @Override
    public WebSocketHandler.WebsocketTuple unwrapBuffer(ByteBuffer buffer) {
        if (this._isWebSocketEnabled.booleanValue()) {
            return this._webSocketHandler.unwrapBuffer(buffer);
        }
        return new WebSocketHandler.WebsocketTuple(0L, WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_UNKNOWN);
    }

    @Override
    public WebSocket.WebSocketState getState() {
        return this._state;
    }

    @Override
    public ByteBuffer getOutputBuffer() {
        return this._outputBuffer;
    }

    @Override
    public ByteBuffer getInputBuffer() {
        return this._inputBuffer;
    }

    @Override
    public ByteBuffer getPingBuffer() {
        return this._pingBuffer;
    }

    @Override
    public ByteBuffer getWsInputBuffer() {
        return this._wsInputBuffer;
    }

    @Override
    public Boolean getEnabled() {
        return this._isWebSocketEnabled;
    }

    @Override
    public WebSocketHandler getWebSocketHandler() {
        return this._webSocketHandler;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketImpl [isWebSocketEnabled=").append(this._isWebSocketEnabled).append(", state=").append((Object)this._state).append(", protocol=").append(this._protocol).append(", host=").append(this._host).append(", path=").append(this._path).append(", port=").append(this._port);
        if (this._additionalHeaders != null && !this._additionalHeaders.isEmpty()) {
            builder.append(", additionalHeaders=");
            for (Map.Entry<String, String> entry : this._additionalHeaders.entrySet()) {
                builder.append(entry.getKey()).append(":").append(entry.getValue()).append(", ");
            }
            int lastIndex = builder.lastIndexOf(", ");
            builder.delete(lastIndex, lastIndex + 2);
        }
        builder.append("]");
        return builder.toString();
    }

    protected void writeUpgradeRequest() {
        this._outputBuffer.clear();
        String request = this._webSocketHandler.createUpgradeRequest(this._host, this._path, this._port, this._protocol, this._additionalHeaders);
        this._outputBuffer.put(request.getBytes());
    }

    protected void writePong() {
        this._webSocketHandler.createPong(this._pingBuffer, this._outputBuffer);
    }

    protected void writeClose() {
        this._outputBuffer.clear();
        this._pingBuffer.flip();
        this._outputBuffer.put(this._pingBuffer);
    }

    private class WebSocketTransportWrapper
    implements TransportWrapper {
        private final TransportInput _underlyingInput;
        private final TransportOutput _underlyingOutput;
        private final ByteBuffer _head;
        public final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private WebSocketTransportWrapper(TransportInput input, TransportOutput output) {
            this._underlyingInput = input;
            this._underlyingOutput = output;
            this._head = WebSocketImpl.this._outputBuffer.asReadOnlyBuffer();
            this._head.limit(0);
        }

        private void readInputBuffer() {
            ByteBufferUtils.pour((ByteBuffer)WebSocketImpl.this._inputBuffer, (ByteBuffer)WebSocketImpl.this._temp);
        }

        private void sendToUnderlyingInput() {
            switch (WebSocketImpl.this._lastType) {
                case WEB_SOCKET_MESSAGE_TYPE_UNKNOWN: 
                case WEB_SOCKET_MESSAGE_TYPE_CHUNK: {
                    WebSocketImpl.this._wsInputBuffer.position(WebSocketImpl.this._wsInputBuffer.limit());
                    WebSocketImpl.this._wsInputBuffer.limit(WebSocketImpl.this._wsInputBuffer.capacity());
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_AMQP: {
                    WebSocketImpl.this._wsInputBuffer.flip();
                    int bytes2 = ByteBufferUtils.pourAll((ByteBuffer)WebSocketImpl.this._wsInputBuffer, (TransportInput)this._underlyingInput);
                    if (bytes2 == -1) {
                        WebSocketImpl.this._tail_closed = true;
                    }
                    WebSocketImpl.this._wsInputBuffer.compact();
                    WebSocketImpl.this._wsInputBuffer.flip();
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_CLOSE: {
                    WebSocketImpl.this._wsInputBuffer.flip();
                    WebSocketImpl.this._pingBuffer.put(WebSocketImpl.this._wsInputBuffer);
                    WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CONNECTED_CLOSING;
                    WebSocketImpl.this._wsInputBuffer.compact();
                    WebSocketImpl.this._wsInputBuffer.flip();
                    break;
                }
                case WEB_SOCKET_MESSAGE_TYPE_PING: {
                    WebSocketImpl.this._wsInputBuffer.flip();
                    WebSocketImpl.this._pingBuffer.put(WebSocketImpl.this._wsInputBuffer);
                    WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CONNECTED_PONG;
                    WebSocketImpl.this._wsInputBuffer.compact();
                    WebSocketImpl.this._wsInputBuffer.flip();
                }
            }
            WebSocketImpl.this._wsInputBuffer.position(WebSocketImpl.this._wsInputBuffer.limit());
            WebSocketImpl.this._wsInputBuffer.limit(WebSocketImpl.this._wsInputBuffer.capacity());
        }

        private void processInput() throws TransportException {
            switch (WebSocketImpl.this._state) {
                case PN_WS_CONNECTING: {
                    if (WebSocketImpl.this._webSocketHandler.validateUpgradeReply(WebSocketImpl.this._inputBuffer).booleanValue()) {
                        WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CONNECTED_FLOW;
                    }
                    WebSocketImpl.this._inputBuffer.compact();
                    break;
                }
                case PN_WS_CONNECTED_FLOW: 
                case PN_WS_CONNECTED_PONG: {
                    if (WebSocketImpl.this._inputBuffer.remaining() > 0) {
                        boolean _readComplete = false;
                        while (!_readComplete) {
                            switch (WebSocketImpl.this._frameReadState) {
                                case INIT_READ: {
                                    WebSocketImpl.this._bytesRead = 0L;
                                    this.readInputBuffer();
                                    WebSocketImpl.this._frameReadState = WebSocketImpl.this._temp.position() < 2 ? WebSocket.WebSocketFrameReadState.CHUNK_READ : WebSocket.WebSocketFrameReadState.HEADER_READ;
                                    _readComplete = WebSocketImpl.this._frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ;
                                    break;
                                }
                                case CHUNK_READ: {
                                    this.readInputBuffer();
                                    WebSocketImpl.this._frameReadState = WebSocketImpl.this._temp.position() < 2 ? WebSocketImpl.this._frameReadState : WebSocket.WebSocketFrameReadState.HEADER_READ;
                                    _readComplete = WebSocketImpl.this._frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ;
                                    break;
                                }
                                case HEADER_READ: {
                                    this.readInputBuffer();
                                    WebSocketImpl.this._temp.flip();
                                    WebSocketHandler.WebsocketTuple unwrapResult = WebSocketImpl.this.unwrapBuffer(WebSocketImpl.this._temp);
                                    WebSocketImpl.this._lastType = unwrapResult.getType();
                                    WebSocketImpl.this._lastLength = unwrapResult.getLength();
                                    WebSocketImpl.this._frameReadState = WebSocketImpl.this._lastType == WebSocketHandler.WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_HEADER_CHUNK ? WebSocket.WebSocketFrameReadState.CHUNK_READ : WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ;
                                    boolean bl = _readComplete = WebSocketImpl.this._frameReadState == WebSocket.WebSocketFrameReadState.CHUNK_READ || WebSocketImpl.this._temp.position() == WebSocketImpl.this._temp.limit();
                                    if (WebSocketImpl.this._frameReadState == WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ) {
                                        WebSocketImpl.this._temp.compact();
                                        break;
                                    }
                                    WebSocketImpl.this._temp.position(WebSocketImpl.this._temp.limit());
                                    WebSocketImpl.this._temp.limit(WebSocketImpl.this._temp.capacity());
                                    break;
                                }
                                case CONTINUED_FRAME_READ: {
                                    byte[] data;
                                    this.readInputBuffer();
                                    WebSocketImpl.this._temp.flip();
                                    if ((long)WebSocketImpl.this._temp.remaining() >= WebSocketImpl.this._lastLength - WebSocketImpl.this._bytesRead) {
                                        data = new byte[(int)(WebSocketImpl.this._lastLength - WebSocketImpl.this._bytesRead)];
                                        WebSocketImpl.this._temp.get(data, 0, (int)(WebSocketImpl.this._lastLength - WebSocketImpl.this._bytesRead));
                                        WebSocketImpl.this._wsInputBuffer.put(data);
                                        WebSocketImpl.this._bytesRead = WebSocketImpl.this._bytesRead + (WebSocketImpl.this._lastLength - WebSocketImpl.this._bytesRead);
                                    } else {
                                        data = new byte[WebSocketImpl.this._temp.remaining()];
                                        WebSocketImpl.this._temp.get(data);
                                        WebSocketImpl.this._wsInputBuffer.put(data);
                                        WebSocketImpl.this._bytesRead = WebSocketImpl.this._bytesRead + (long)data.length;
                                    }
                                    this.sendToUnderlyingInput();
                                    WebSocketImpl.this._frameReadState = WebSocketImpl.this._bytesRead == WebSocketImpl.this._lastLength ? WebSocket.WebSocketFrameReadState.INIT_READ : WebSocket.WebSocketFrameReadState.CONTINUED_FRAME_READ;
                                    _readComplete = WebSocketImpl.this._temp.remaining() == 0;
                                    WebSocketImpl.this._temp.compact();
                                    break;
                                }
                            }
                        }
                    }
                    WebSocketImpl.this._inputBuffer.compact();
                    break;
                }
            }
        }

        public int capacity() {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                if (WebSocketImpl.this._tail_closed) {
                    return -1;
                }
                return WebSocketImpl.this._inputBuffer.remaining();
            }
            return this._underlyingInput.capacity();
        }

        public int position() {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                if (WebSocketImpl.this._tail_closed) {
                    return -1;
                }
                return WebSocketImpl.this._inputBuffer.position();
            }
            return this._underlyingInput.position();
        }

        public ByteBuffer tail() {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                return WebSocketImpl.this._inputBuffer;
            }
            return this._underlyingInput.tail();
        }

        public void process() throws TransportException {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                WebSocketImpl.this._inputBuffer.flip();
                switch (WebSocketImpl.this._state) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_FLOW: {
                        this.processInput();
                        break;
                    }
                    default: {
                        this._underlyingInput.process();
                        break;
                    }
                }
            } else {
                this._underlyingInput.process();
            }
        }

        public void close_tail() {
            WebSocketImpl.this._tail_closed = true;
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                WebSocketImpl.this._head_closed = true;
            }
            this._underlyingInput.close_tail();
        }

        public int pending() {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                switch (WebSocketImpl.this._state) {
                    case PN_WS_NOT_STARTED: {
                        if (WebSocketImpl.this._outputBuffer.position() == 0) {
                            WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CONNECTING;
                            WebSocketImpl.this.writeUpgradeRequest();
                            this._head.limit(WebSocketImpl.this._outputBuffer.position());
                            if (WebSocketImpl.this._head_closed) {
                                WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_FAILED;
                                return -1;
                            }
                            return WebSocketImpl.this._outputBuffer.position();
                        }
                        return WebSocketImpl.this._outputBuffer.position();
                    }
                    case PN_WS_CONNECTING: {
                        if (WebSocketImpl.this._head_closed && WebSocketImpl.this._outputBuffer.position() == 0) {
                            WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this._outputBuffer.position();
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        WebSocketImpl.this._underlyingOutputSize = this._underlyingOutput.pending();
                        if (WebSocketImpl.this._underlyingOutputSize > 0) {
                            WebSocketImpl.this._webSocketHeaderSize = WebSocketImpl.this._webSocketHandler.calculateHeaderSize(WebSocketImpl.this._underlyingOutputSize);
                            return WebSocketImpl.this._underlyingOutputSize + WebSocketImpl.this._webSocketHeaderSize;
                        }
                        return WebSocketImpl.this._underlyingOutputSize;
                    }
                    case PN_WS_CONNECTED_PONG: {
                        WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CONNECTED_FLOW;
                        WebSocketImpl.this.writePong();
                        this._head.limit(WebSocketImpl.this._outputBuffer.position());
                        if (WebSocketImpl.this._head_closed) {
                            WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this._outputBuffer.position();
                    }
                    case PN_WS_CONNECTED_CLOSING: {
                        WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_CLOSED;
                        WebSocketImpl.this.writeClose();
                        this._head.limit(WebSocketImpl.this._outputBuffer.position());
                        if (WebSocketImpl.this._head_closed) {
                            WebSocketImpl.this._state = WebSocket.WebSocketState.PN_WS_FAILED;
                            return -1;
                        }
                        return WebSocketImpl.this._outputBuffer.position();
                    }
                }
                return -1;
            }
            return this._underlyingOutput.pending();
        }

        public ByteBuffer head() {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                switch (WebSocketImpl.this._state) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_PONG: 
                    case PN_WS_CONNECTED_CLOSING: {
                        return this._head;
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        WebSocketImpl.this._underlyingOutputSize = this._underlyingOutput.pending();
                        if (WebSocketImpl.this._underlyingOutputSize > 0) {
                            WebSocketImpl.this.wrapBuffer(this._underlyingOutput.head(), WebSocketImpl.this._outputBuffer);
                            WebSocketImpl.this._webSocketHeaderSize = WebSocketImpl.this._outputBuffer.position() - WebSocketImpl.this._underlyingOutputSize;
                            this._head.limit(WebSocketImpl.this._outputBuffer.position());
                        }
                        return this._head;
                    }
                }
                return this._underlyingOutput.head();
            }
            return this._underlyingOutput.head();
        }

        public void pop(int bytes) {
            if (WebSocketImpl.this._isWebSocketEnabled.booleanValue()) {
                switch (WebSocketImpl.this._state) {
                    case PN_WS_CONNECTING: {
                        if (WebSocketImpl.this._outputBuffer.position() != 0) {
                            WebSocketImpl.this._outputBuffer.flip();
                            WebSocketImpl.this._outputBuffer.position(bytes);
                            WebSocketImpl.this._outputBuffer.compact();
                            this._head.position(0);
                            this._head.limit(WebSocketImpl.this._outputBuffer.position());
                            break;
                        }
                        this._underlyingOutput.pop(bytes);
                        break;
                    }
                    case PN_WS_CONNECTED_FLOW: 
                    case PN_WS_CONNECTED_PONG: 
                    case PN_WS_CONNECTED_CLOSING: {
                        if (bytes >= WebSocketImpl.this._webSocketHeaderSize && WebSocketImpl.this._outputBuffer.position() != 0) {
                            WebSocketImpl.this._outputBuffer.flip();
                            WebSocketImpl.this._outputBuffer.position(bytes);
                            WebSocketImpl.this._outputBuffer.compact();
                            this._head.position(0);
                            this._head.limit(WebSocketImpl.this._outputBuffer.position());
                            this._underlyingOutput.pop(bytes - WebSocketImpl.this._webSocketHeaderSize);
                            WebSocketImpl.this._webSocketHeaderSize = 0;
                            break;
                        }
                        if (bytes > 0 && bytes < WebSocketImpl.this._webSocketHeaderSize) {
                            WebSocketImpl.this._webSocketHeaderSize = WebSocketImpl.this._webSocketHeaderSize - bytes;
                            break;
                        }
                        this._underlyingOutput.pop(bytes);
                        break;
                    }
                    case PN_WS_NOT_STARTED: 
                    case PN_WS_CLOSED: 
                    case PN_WS_FAILED: {
                        this._underlyingOutput.pop(bytes);
                    }
                }
            } else {
                this._underlyingOutput.pop(bytes);
            }
        }

        public void close_head() {
            this._underlyingOutput.close_head();
        }

        private String convertToHex(byte[] bb) {
            int lgt = bb.length;
            char[] out = new char[5 * lgt];
            int j = 0;
            for (int i = 0; i < lgt; ++i) {
                out[j++] = 48;
                out[j++] = 120;
                out[j++] = this.HEX_DIGITS[(0xF0 & bb[i]) >>> 4];
                out[j++] = this.HEX_DIGITS[0xF & bb[i]];
                out[j++] = 124;
            }
            return new String(out);
        }

        private String convertToHex(ByteBuffer bb) {
            byte[] data = new byte[bb.remaining()];
            bb.duplicate().get(data);
            return this.convertToHex(data);
        }

        private String convertToBinary(byte[] bb) {
            StringBuilder sb = new StringBuilder();
            for (byte b : bb) {
                sb.append(String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0'));
                sb.append('|');
            }
            return sb.toString();
        }

        private String convertToBinary(ByteBuffer bb) {
            byte[] data = new byte[bb.remaining()];
            bb.duplicate().get(data);
            return this.convertToBinary(data);
        }
    }
}

