/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.RegisterManagerParser;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinChangedCallback;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinConnectionState;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinProperties;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinStatus;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinTags;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class TwinParser {
    private TwinChangedCallback onDesiredCallback = null;
    private TwinChangedCallback onReportedCallback = null;
    private static TwinChangedCallback onTagsCallback = null;
    private static final String TAGS_TAG = "tags";
    private static final String PROPERTIES_TAG = "properties";
    private static final String DESIRED_TAG = "desired";
    private static final String REPORTED_TAG = "reported";
    private static final int MAX_MAP_LEVEL = 5;
    protected TwinTags tags = null;
    protected TwinProperties properties = new TwinProperties();
    protected RegisterManagerParser manager = new RegisterManagerParser();

    public TwinParser() {
    }

    public TwinParser(TwinChangedCallback onDesiredCallback) {
        this();
        this.setDesiredCallback(onDesiredCallback);
    }

    public TwinParser(TwinChangedCallback onDesiredCallback, TwinChangedCallback onReportedCallback) {
        this();
        this.setDesiredCallback(onDesiredCallback);
        this.setReportedCallback(onReportedCallback);
    }

    public void setDesiredCallback(TwinChangedCallback onDesiredCallback) {
        this.onDesiredCallback = onDesiredCallback;
    }

    public void setReportedCallback(TwinChangedCallback onReportedCallback) {
        this.onReportedCallback = onReportedCallback;
    }

    public void setTagsCallback(TwinChangedCallback onTagsCallback) {
        TwinParser.onTagsCallback = onTagsCallback;
    }

    public String toJson() {
        return this.toJsonElement().toString();
    }

    public JsonElement toJsonElement() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonObject twinJson = gson.toJsonTree((Object)this.manager).getAsJsonObject();
        if (this.tags != null) {
            twinJson.add(TAGS_TAG, this.tags.toJsonElement());
        }
        twinJson.add(PROPERTIES_TAG, this.properties.toJsonElement());
        return twinJson;
    }

    public void enableTags() {
        if (this.tags == null) {
            this.tags = new TwinTags();
        }
    }

    public void enableMetadata() {
        this.properties.enableDesiredMetadata();
        this.properties.enableReportedMetadata();
    }

    public String updateTwin(Map<String, Object> desiredPropertyMap, Map<String, Object> reportedPropertyMap, Map<String, Object> tagsMap) throws IllegalArgumentException, IOException {
        JsonObject jsonProperty = new JsonObject();
        this.validateMap(desiredPropertyMap);
        this.validateMap(reportedPropertyMap);
        this.validateMap(tagsMap);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonObject jsonTwin = gson.toJsonTree((Object)this.manager).getAsJsonObject();
        if (this.tags == null && tagsMap != null) {
            throw new IOException("Update not enabled Tags");
        }
        if (desiredPropertyMap == null && reportedPropertyMap == null && tagsMap == null) {
            throw new IllegalArgumentException("Null maps");
        }
        JsonElement jsonDesiredProperty = this.innerUpdateDesiredProperty(desiredPropertyMap);
        if (jsonDesiredProperty != null) {
            jsonProperty.add(DESIRED_TAG, jsonDesiredProperty);
        } else {
            jsonProperty.add(DESIRED_TAG, (JsonElement)new JsonObject());
        }
        JsonElement jsonReportedProperty = this.innerUpdateReportedProperty(reportedPropertyMap);
        if (jsonReportedProperty != null) {
            jsonProperty.add(REPORTED_TAG, jsonReportedProperty);
        } else {
            jsonProperty.add(REPORTED_TAG, (JsonElement)new JsonObject());
        }
        JsonElement jsonTags = null;
        if (this.tags != null) {
            if (tagsMap == null) {
                jsonTwin.add(TAGS_TAG, (JsonElement)new JsonObject());
            } else {
                jsonTags = this.innerUpdateTags(tagsMap);
                if (jsonTags != null) {
                    jsonTwin.add(TAGS_TAG, jsonTags);
                } else {
                    jsonTwin.add(TAGS_TAG, (JsonElement)new JsonObject());
                }
            }
        }
        if (jsonDesiredProperty == null && jsonReportedProperty == null && jsonTags == null) {
            return null;
        }
        jsonTwin.add(PROPERTIES_TAG, (JsonElement)jsonProperty);
        return jsonTwin.toString();
    }

    public String updateDesiredProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        if (propertyMap == null) {
            throw new IllegalArgumentException("Null desired property map.");
        }
        JsonElement jsonElement = this.innerUpdateDesiredProperty(propertyMap);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.toString();
    }

    private JsonElement innerUpdateDesiredProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        JsonElement updatedElements;
        if (propertyMap != null) {
            this.validateMap(propertyMap);
            updatedElements = this.properties.updateDesired(propertyMap);
        } else {
            updatedElements = null;
        }
        return updatedElements;
    }

    public String updateReportedProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        if (propertyMap == null) {
            throw new IllegalArgumentException("Null reported property map.");
        }
        JsonElement jsonElement = this.innerUpdateReportedProperty(propertyMap);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.toString();
    }

    private JsonElement innerUpdateReportedProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        JsonElement updatedElements;
        if (propertyMap != null) {
            this.validateMap(propertyMap);
            updatedElements = this.properties.updateReported(propertyMap);
        } else {
            updatedElements = null;
        }
        return updatedElements;
    }

    public String updateTags(Map<String, Object> tagsMap) throws IllegalArgumentException, IOException {
        JsonElement jsonElement = this.innerUpdateTags(tagsMap);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.toString();
    }

    private JsonElement innerUpdateTags(Map<String, Object> tagsMap) throws IllegalArgumentException, IOException {
        if (this.tags == null) {
            throw new IOException("Update not enabled Tags");
        }
        if (tagsMap == null) {
            throw new IllegalArgumentException("Null tags map");
        }
        this.validateMap(tagsMap);
        JsonElement updatedElements = this.tags.update(tagsMap);
        return updatedElements;
    }

    public String resetDesiredProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        String json;
        if (propertyMap != null) {
            this.validateMap(propertyMap);
            JsonElement updatedElements = this.properties.resetDesired(propertyMap);
            json = updatedElements == null ? "{}" : updatedElements.toString();
        } else {
            throw new IllegalArgumentException("Null property map");
        }
        return json;
    }

    public String resetReportedProperty(Map<String, Object> propertyMap) throws IllegalArgumentException {
        String json;
        if (propertyMap != null) {
            this.validateMap(propertyMap);
            JsonElement updatedElements = this.properties.resetReported(propertyMap);
            json = updatedElements == null ? "{}" : updatedElements.toString();
        } else {
            throw new IllegalArgumentException("Null property map");
        }
        return json;
    }

    public String resetTags(Map<String, Object> tagsMap) throws IllegalArgumentException, IOException {
        String json;
        if (this.tags == null) {
            throw new IOException("Update not enabled Tags");
        }
        if (tagsMap != null) {
            this.validateMap(tagsMap);
            this.tags = new TwinTags();
            JsonElement updatedElements = this.tags.update(tagsMap);
            json = updatedElements == null ? "{}" : updatedElements.toString();
        } else {
            throw new IllegalArgumentException("Null tags map");
        }
        return json;
    }

    public void updateTwin(String json) throws IllegalArgumentException {
        if (json == null) {
            throw new IllegalArgumentException("Null json");
        }
        this.validateJson(json);
        if (!json.isEmpty()) {
            Map jsonTree;
            Gson gson = new GsonBuilder().disableInnerClassSerialization().disableHtmlEscaping().create();
            try {
                jsonTree = (Map)gson.fromJson(json, HashMap.class);
                this.manager = (RegisterManagerParser)gson.fromJson(json, RegisterManagerParser.class);
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException("Malformed Json: " + (Object)((Object)e));
            }
            boolean propertiesLevel = false;
            for (Map.Entry entry : jsonTree.entrySet()) {
                if (((String)entry.getKey()).equals(PROPERTIES_TAG)) {
                    this.properties.update((Map)entry.getValue(), this.onDesiredCallback, this.onReportedCallback);
                    propertiesLevel = true;
                    continue;
                }
                if (((String)entry.getKey()).equals(DESIRED_TAG) || ((String)entry.getKey()).equals(REPORTED_TAG)) {
                    if (!propertiesLevel) {
                        this.properties.update(jsonTree, this.onDesiredCallback, this.onReportedCallback);
                        break;
                    }
                    throw new IllegalArgumentException("Invalid Entry");
                }
                if (!((String)entry.getKey()).equals(TAGS_TAG)) continue;
                if (this.tags != null) {
                    this.tags.update((Map)entry.getValue(), onTagsCallback);
                }
                propertiesLevel = true;
            }
        }
    }

    public void updateDesiredProperty(String json) throws IllegalArgumentException {
        if (json == null) {
            throw new IllegalArgumentException("Null json");
        }
        if (!json.isEmpty()) {
            try {
                this.properties.updateDesired(json, this.onDesiredCallback);
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException("Malformed json: " + (Object)((Object)e));
            }
        }
    }

    public void updateReportedProperty(String json) throws IllegalArgumentException {
        if (json == null) {
            throw new IllegalArgumentException("Null json");
        }
        if (!json.isEmpty()) {
            try {
                this.properties.updateReported(json, this.onReportedCallback);
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException("Malformed json: " + (Object)((Object)e));
            }
        }
    }

    public String updateDeviceManager(String deviceId, TwinStatus status, String statusReason) throws IllegalArgumentException {
        boolean change = false;
        this.manager.validateDeviceManager(deviceId, status, statusReason);
        if (this.manager.setStatus(status, statusReason)) {
            change = true;
        }
        if (this.manager.setDeviceId(deviceId)) {
            change = true;
        }
        if (!change) {
            return null;
        }
        return this.toJson();
    }

    public Integer getDesiredPropertyVersion() {
        return this.properties.getDesiredVersion();
    }

    public Integer getReportedPropertyVersion() {
        return this.properties.getReportedVersion();
    }

    public Map<String, Object> getDesiredPropertyMap() {
        return this.properties.getDesiredPropertyMap();
    }

    public Map<String, Object> getReportedPropertyMap() {
        return this.properties.getReportedPropertyMap();
    }

    public Map<String, Object> getTagsMap() throws IOException {
        if (this.tags == null) {
            throw new IOException("Update not enabled Tags");
        }
        return this.tags.getMap();
    }

    public String getDeviceId() {
        return this.manager.deviceId;
    }

    public void setDeviceId(String deviceId) throws IllegalArgumentException {
        ParserUtility.validateId(deviceId);
        this.manager.setDeviceId(deviceId);
    }

    public String getGenerationId() {
        return this.manager.generationId;
    }

    public String getETag() {
        return this.manager.eTag;
    }

    public Integer getVersion() {
        return this.manager.version;
    }

    public void setETag(String eTag) throws IllegalArgumentException {
        ParserUtility.validateStringUTF8(eTag);
        this.manager.eTag = eTag;
    }

    public TwinStatus getStatus() {
        return this.manager.status;
    }

    public String getStatusReason() {
        return this.manager.statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.manager.statusUpdatedTime;
    }

    public TwinConnectionState getConnectionState() {
        return this.manager.connectionState;
    }

    public String getConnectionStateUpdatedTime() {
        return this.manager.connectionStateUpdatedTime;
    }

    public String getLastActivityTime() {
        return this.manager.lastActivityTime;
    }

    private void validateJson(String json) throws IllegalArgumentException {
        Map map;
        try {
            Gson gson = new GsonBuilder().disableInnerClassSerialization().disableHtmlEscaping().create();
            map = (Map)gson.fromJson(json, HashMap.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed Json: " + e);
        }
        if (map != null) {
            boolean propertiesLevel = false;
            boolean containsTagsOrProperties = false;
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).equals(PROPERTIES_TAG)) {
                    this.properties.validate((Map)entry.getValue());
                    propertiesLevel = true;
                    containsTagsOrProperties = true;
                    continue;
                }
                if (((String)entry.getKey()).equals(DESIRED_TAG) || ((String)entry.getKey()).equals(REPORTED_TAG)) {
                    if (!propertiesLevel) {
                        this.properties.validate(map);
                        containsTagsOrProperties = true;
                        break;
                    }
                    throw new IllegalArgumentException("Invalid Entry");
                }
                if (!((String)entry.getKey()).equals(TAGS_TAG)) continue;
                if (this.tags != null) {
                    this.tags.validate((Map)entry.getValue());
                }
                propertiesLevel = true;
                containsTagsOrProperties = true;
            }
            if (!containsTagsOrProperties) {
                throw new IllegalArgumentException("Json do not contains twin information");
            }
        }
    }

    private void validateMap(Map<String, Object> map) throws IllegalArgumentException {
        if (map != null) {
            this.validateMap(map, 0, 5, false);
        }
    }

    private void validateMap(Map<String, Object> map, int level, int maxLevel, boolean allowDollar) throws IllegalArgumentException {
        ++level;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ParserUtility.validateKey(key, allowDollar);
            if (value != null && (value.getClass().isArray() || value.getClass().isLocalClass())) {
                throw new IllegalArgumentException("Malformed Json: illegal value type");
            }
            if (value == null || !(value instanceof Map)) continue;
            if (level <= maxLevel) {
                this.validateMap((Map)value, level, maxLevel, allowDollar);
                continue;
            }
            throw new IllegalArgumentException("Malformed Json: exceed 5 levels");
        }
    }
}

