/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.amqp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AmqpMessage {
    MessageImpl messageImpl;

    public AmqpMessage() {
        this.messageImpl = (MessageImpl)Proton.message();
    }

    public AmqpMessage(MessageImpl messageImpl) {
        this.messageImpl = messageImpl;
    }

    public void setBody(Data msgData) {
        this.messageImpl.setBody((Section)msgData);
    }

    public void setBody(byte[] msgData) {
        Binary binary = new Binary(msgData);
        Data dataSection = new Data(binary);
        this.messageImpl.setBody((Section)dataSection);
    }

    public byte[] getAmqpBody() {
        Data msgData = (Data)this.messageImpl.getBody();
        Binary binData = msgData.getValue();
        byte[] msgBody = new byte[binData.getLength()];
        ByteBuffer buffer = binData.asByteBuffer();
        buffer.get(msgBody);
        return msgBody;
    }

    public void setApplicationProperty(Map<String, Object> userProperties) {
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        this.messageImpl.setApplicationProperties(applicationProperties);
    }

    public Map<String, Object> getApplicationProperty() {
        ApplicationProperties appProperty = this.messageImpl.getApplicationProperties();
        if (appProperty == null) {
            return null;
        }
        return appProperty.getValue();
    }

    public void decode(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null.");
        }
        this.messageImpl.decode(data, offset, length);
    }

    public int encode(byte[] data, int offset) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("The data cannot be null.");
        }
        return this.messageImpl.encode(data, offset, data.length);
    }
}

