/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import javax.net.ssl.SSLContext;

public final class MultiplexingClientOptions {
    private final ProxySettings proxySettings;
    private final SSLContext sslContext;
    private final long sendInterval;
    private final long receiveInterval;
    private final int maxMessagesSentPerSendInterval;
    public final int keepAliveInterval;
    private final String threadNamePrefix;
    private final String threadNameSuffix;
    private final boolean useIdentifiableThreadNames;
    private final long messageExpirationCheckPeriod;

    public boolean isUsingIdentifiableThreadNames() {
        return this.useIdentifiableThreadNames;
    }

    private static long $default$sendInterval() {
        return 10L;
    }

    private static long $default$receiveInterval() {
        return 10L;
    }

    private static int $default$maxMessagesSentPerSendInterval() {
        return 10;
    }

    private static int $default$keepAliveInterval() {
        return 230;
    }

    private static String $default$threadNamePrefix() {
        return null;
    }

    private static String $default$threadNameSuffix() {
        return null;
    }

    private static boolean $default$useIdentifiableThreadNames() {
        return true;
    }

    private static long $default$messageExpirationCheckPeriod() {
        return 10000L;
    }

    MultiplexingClientOptions(ProxySettings proxySettings, SSLContext sslContext, long sendInterval, long receiveInterval, int maxMessagesSentPerSendInterval, int keepAliveInterval, String threadNamePrefix, String threadNameSuffix, boolean useIdentifiableThreadNames, long messageExpirationCheckPeriod) {
        this.proxySettings = proxySettings;
        this.sslContext = sslContext;
        this.sendInterval = sendInterval;
        this.receiveInterval = receiveInterval;
        this.maxMessagesSentPerSendInterval = maxMessagesSentPerSendInterval;
        this.keepAliveInterval = keepAliveInterval;
        this.threadNamePrefix = threadNamePrefix;
        this.threadNameSuffix = threadNameSuffix;
        this.useIdentifiableThreadNames = useIdentifiableThreadNames;
        this.messageExpirationCheckPeriod = messageExpirationCheckPeriod;
    }

    public static MultiplexingClientOptionsBuilder builder() {
        return new MultiplexingClientOptionsBuilder();
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public long getSendInterval() {
        return this.sendInterval;
    }

    public long getReceiveInterval() {
        return this.receiveInterval;
    }

    public int getMaxMessagesSentPerSendInterval() {
        return this.maxMessagesSentPerSendInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public String getThreadNameSuffix() {
        return this.threadNameSuffix;
    }

    public long getMessageExpirationCheckPeriod() {
        return this.messageExpirationCheckPeriod;
    }

    public static class MultiplexingClientOptionsBuilder {
        private ProxySettings proxySettings;
        private SSLContext sslContext;
        private boolean sendInterval$set;
        private long sendInterval$value;
        private boolean receiveInterval$set;
        private long receiveInterval$value;
        private boolean maxMessagesSentPerSendInterval$set;
        private int maxMessagesSentPerSendInterval$value;
        private boolean keepAliveInterval$set;
        private int keepAliveInterval$value;
        private boolean threadNamePrefix$set;
        private String threadNamePrefix$value;
        private boolean threadNameSuffix$set;
        private String threadNameSuffix$value;
        private boolean useIdentifiableThreadNames$set;
        private boolean useIdentifiableThreadNames$value;
        private boolean messageExpirationCheckPeriod$set;
        private long messageExpirationCheckPeriod$value;

        MultiplexingClientOptionsBuilder() {
        }

        public MultiplexingClientOptionsBuilder proxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public MultiplexingClientOptionsBuilder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public MultiplexingClientOptionsBuilder sendInterval(long sendInterval) {
            this.sendInterval$value = sendInterval;
            this.sendInterval$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder receiveInterval(long receiveInterval) {
            this.receiveInterval$value = receiveInterval;
            this.receiveInterval$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder maxMessagesSentPerSendInterval(int maxMessagesSentPerSendInterval) {
            this.maxMessagesSentPerSendInterval$value = maxMessagesSentPerSendInterval;
            this.maxMessagesSentPerSendInterval$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder keepAliveInterval(int keepAliveInterval) {
            this.keepAliveInterval$value = keepAliveInterval;
            this.keepAliveInterval$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix$value = threadNamePrefix;
            this.threadNamePrefix$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder threadNameSuffix(String threadNameSuffix) {
            this.threadNameSuffix$value = threadNameSuffix;
            this.threadNameSuffix$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder useIdentifiableThreadNames(boolean useIdentifiableThreadNames) {
            this.useIdentifiableThreadNames$value = useIdentifiableThreadNames;
            this.useIdentifiableThreadNames$set = true;
            return this;
        }

        public MultiplexingClientOptionsBuilder messageExpirationCheckPeriod(long messageExpirationCheckPeriod) {
            this.messageExpirationCheckPeriod$value = messageExpirationCheckPeriod;
            this.messageExpirationCheckPeriod$set = true;
            return this;
        }

        public MultiplexingClientOptions build() {
            long sendInterval$value = this.sendInterval$value;
            if (!this.sendInterval$set) {
                sendInterval$value = MultiplexingClientOptions.$default$sendInterval();
            }
            long receiveInterval$value = this.receiveInterval$value;
            if (!this.receiveInterval$set) {
                receiveInterval$value = MultiplexingClientOptions.$default$receiveInterval();
            }
            int maxMessagesSentPerSendInterval$value = this.maxMessagesSentPerSendInterval$value;
            if (!this.maxMessagesSentPerSendInterval$set) {
                maxMessagesSentPerSendInterval$value = MultiplexingClientOptions.$default$maxMessagesSentPerSendInterval();
            }
            int keepAliveInterval$value = this.keepAliveInterval$value;
            if (!this.keepAliveInterval$set) {
                keepAliveInterval$value = MultiplexingClientOptions.$default$keepAliveInterval();
            }
            String threadNamePrefix$value = this.threadNamePrefix$value;
            if (!this.threadNamePrefix$set) {
                threadNamePrefix$value = MultiplexingClientOptions.$default$threadNamePrefix();
            }
            String threadNameSuffix$value = this.threadNameSuffix$value;
            if (!this.threadNameSuffix$set) {
                threadNameSuffix$value = MultiplexingClientOptions.$default$threadNameSuffix();
            }
            boolean useIdentifiableThreadNames$value = this.useIdentifiableThreadNames$value;
            if (!this.useIdentifiableThreadNames$set) {
                useIdentifiableThreadNames$value = MultiplexingClientOptions.$default$useIdentifiableThreadNames();
            }
            long messageExpirationCheckPeriod$value = this.messageExpirationCheckPeriod$value;
            if (!this.messageExpirationCheckPeriod$set) {
                messageExpirationCheckPeriod$value = MultiplexingClientOptions.$default$messageExpirationCheckPeriod();
            }
            return new MultiplexingClientOptions(this.proxySettings, this.sslContext, sendInterval$value, receiveInterval$value, maxMessagesSentPerSendInterval$value, keepAliveInterval$value, threadNamePrefix$value, threadNameSuffix$value, useIdentifiableThreadNames$value, messageExpirationCheckPeriod$value);
        }

        public String toString() {
            return "MultiplexingClientOptions.MultiplexingClientOptionsBuilder(proxySettings=" + this.proxySettings + ", sslContext=" + this.sslContext + ", sendInterval$value=" + this.sendInterval$value + ", receiveInterval$value=" + this.receiveInterval$value + ", maxMessagesSentPerSendInterval$value=" + this.maxMessagesSentPerSendInterval$value + ", keepAliveInterval$value=" + this.keepAliveInterval$value + ", threadNamePrefix$value=" + this.threadNamePrefix$value + ", threadNameSuffix$value=" + this.threadNameSuffix$value + ", useIdentifiableThreadNames$value=" + this.useIdentifiableThreadNames$value + ", messageExpirationCheckPeriod$value=" + this.messageExpirationCheckPeriod$value + ")";
        }
    }
}

