/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.SasTokenProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import javax.net.ssl.SSLContext;

public class IotHubSasTokenProvidedAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    private final SasTokenProvider sasTokenProvider;
    private char[] lastSasToken;

    public IotHubSasTokenProvidedAuthenticationProvider(String hostName, String deviceId, String moduleId, SasTokenProvider sasTokenProvider, SSLContext sslContext) {
        super(hostName, null, deviceId, moduleId, sslContext);
        if (sasTokenProvider == null) {
            throw new IllegalArgumentException("SAS token provider cannot be null");
        }
        this.sasTokenProvider = sasTokenProvider;
    }

    @Override
    public boolean isAuthenticationProviderRenewalNecessary() {
        return false;
    }

    @Override
    public void setTokenValidSecs(long tokenValidSecs) {
        throw new UnsupportedOperationException("Cannot configure SAS token time to live when custom SAS token provider is in use");
    }

    @Override
    public boolean canRefreshToken() {
        return true;
    }

    @Override
    public char[] getSasToken() {
        this.lastSasToken = this.sasTokenProvider.getSasToken();
        return this.lastSasToken;
    }

    @Override
    public int getMillisecondsBeforeProactiveRenewal() {
        long expiryTimeSeconds = IotHubSasToken.getExpiryTimeFromToken(new String(this.lastSasToken));
        long tokenValidSeconds = expiryTimeSeconds - System.currentTimeMillis() / 1000L;
        double timeBufferMultiplier = (double)this.timeBufferPercentage / 100.0;
        return (int)((double)(tokenValidSeconds * 1000L) * timeBufferMultiplier);
    }

    @Override
    public boolean isSasTokenExpired() {
        return this.lastSasToken != null && IotHubSasToken.isExpired(new String(this.lastSasToken));
    }
}

