/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.device.auth.IotHubSasToken;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IotHubSasTokenWithRefreshAuthenticationProvider
extends IotHubSasTokenAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(IotHubSasTokenWithRefreshAuthenticationProvider.class);

    protected IotHubSasTokenWithRefreshAuthenticationProvider(String hostname, String gatewayHostName, String deviceId, String moduleId, String sharedAccessToken, int suggestedTimeToLiveSeconds, int timeBufferPercentage) {
        super(hostname, gatewayHostName, deviceId, moduleId, suggestedTimeToLiveSeconds, timeBufferPercentage);
        this.sasToken = new IotHubSasToken(hostname, deviceId, null, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    protected IotHubSasTokenWithRefreshAuthenticationProvider(String hostname, String gatewayHostName, String deviceId, String moduleId, String sharedAccessToken, int suggestedTimeToLiveSeconds, int timeBufferPercentage, SSLContext sslContext) {
        super(hostname, gatewayHostName, deviceId, moduleId, suggestedTimeToLiveSeconds, timeBufferPercentage, sslContext);
        this.sasToken = new IotHubSasToken(hostname, deviceId, null, sharedAccessToken, moduleId, this.getExpiryTimeInSeconds());
    }

    protected static String buildAudience(String hostname, String deviceId, String moduleId) throws UnsupportedEncodingException {
        if (hostname == null || deviceId == null || moduleId == null || hostname.isEmpty() || deviceId.isEmpty() || moduleId.isEmpty()) {
            throw new IllegalArgumentException("No argument can be null or empty");
        }
        return URLEncoder.encode(String.format("%s/devices/%s/modules/%s", hostname, deviceId, moduleId), StandardCharsets.UTF_8.name());
    }

    @Override
    public boolean isAuthenticationProviderRenewalNecessary() {
        return false;
    }

    public abstract void refreshSasToken() throws IOException, TransportException;

    @Override
    public char[] getSasToken() throws IOException, TransportException {
        log.debug("Renewing the internal sas token");
        this.refreshSasToken();
        return this.sasToken.toString().toCharArray();
    }
}

