/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.exceptions;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;

public class IotHubClientException
extends Exception {
    private final IotHubStatusCode statusCode;
    private final boolean isRetryable;

    public IotHubClientException(IotHubStatusCode statusCode) {
        this(statusCode, "");
    }

    public IotHubClientException(IotHubStatusCode statusCode, String errorMessage) {
        super(errorMessage);
        this.isRetryable = IotHubStatusCode.isRetryable(statusCode);
        this.statusCode = statusCode;
    }

    public IotHubClientException(IotHubStatusCode statusCode, Exception nestedException) {
        this(statusCode, "", nestedException);
    }

    public IotHubClientException(IotHubStatusCode statusCode, String errorMessage, Exception nestedException) {
        super(errorMessage, nestedException);
        this.isRetryable = IotHubStatusCode.isRetryable(statusCode);
        this.statusCode = statusCode;
    }

    public IotHubStatusCode getStatusCode() {
        return this.statusCode;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }
}

