/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.hsm;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.hsm.HttpsRequestResponseSerializer;
import com.microsoft.azure.sdk.iot.device.hsm.UnixDomainSocketChannel;
import com.microsoft.azure.sdk.iot.device.hsm.parser.ErrorResponse;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignRequest;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignResponse;
import com.microsoft.azure.sdk.iot.device.hsm.parser.TrustBundleResponse;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsRequest;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsHsmClient {
    private static final Logger log = LoggerFactory.getLogger(HttpsHsmClient.class);
    private final String baseUrl;
    private final String scheme;
    private final UnixDomainSocketChannel unixDomainSocketChannel;
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String UNIX_SCHEME = "unix";
    private static final String API_VERSION_QUERY_STRING_PREFIX = "api-version=";

    public HttpsHsmClient(String baseUrl, UnixDomainSocketChannel unixDomainSocketChannel) throws URISyntaxException {
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new IllegalArgumentException("baseUrl cannot be null");
        }
        log.trace("Creating HttpsHsmClient with base url {}", (Object)baseUrl);
        this.baseUrl = baseUrl;
        this.scheme = new URI(baseUrl).getScheme();
        this.unixDomainSocketChannel = unixDomainSocketChannel;
    }

    public SignResponse sign(String apiVersion, String moduleName, SignRequest signRequest, String generationId) throws TransportException, UnsupportedEncodingException {
        log.debug("Sending sign request...");
        String uri = this.baseUrl != null ? this.baseUrl.replaceFirst("/*$", "") : "";
        byte[] body = signRequest.toJson().getBytes(StandardCharsets.UTF_8);
        String pathBuilder = "/modules/" + URLEncoder.encode(moduleName, StandardCharsets.UTF_8.name()) + "/genid/" + URLEncoder.encode(generationId, StandardCharsets.UTF_8.name()) + "/sign";
        HttpsResponse response = null;
        try {
            response = this.sendRequestBasedOnScheme(HttpsMethod.POST, body, uri, pathBuilder, API_VERSION_QUERY_STRING_PREFIX + apiVersion);
        }
        catch (IOException e) {
            throw new TransportException("Could not send request to HSM", e);
        }
        int responseCode = response.getStatus();
        String responseBody = new String(response.getBody(), StandardCharsets.UTF_8);
        if (responseCode >= 200 && responseCode < 300) {
            return SignResponse.fromJson(responseBody);
        }
        String exceptionMessage = "HttpsHsmClient received status code " + responseCode + " from provided uri.";
        ErrorResponse errorResponse = ErrorResponse.fromJson(responseBody);
        if (errorResponse != null) {
            exceptionMessage = exceptionMessage + " Error response message: " + errorResponse.getMessage();
        }
        throw IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(responseCode), exceptionMessage);
    }

    public TrustBundleResponse getTrustBundle(String apiVersion) throws TransportException {
        String body;
        log.debug("Getting trust bundle...");
        if (apiVersion == null || apiVersion.isEmpty()) {
            throw new IllegalArgumentException("api version cannot be null or empty");
        }
        String uri = this.baseUrl != null ? this.baseUrl.replaceFirst("/*$", "") : "";
        HttpsResponse response = null;
        try {
            response = this.sendRequestBasedOnScheme(HttpsMethod.GET, new byte[0], uri, "/trust-bundle", API_VERSION_QUERY_STRING_PREFIX + apiVersion);
        }
        catch (IOException e) {
            throw IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.IO_ERROR, "Could not send request to HSM");
        }
        int statusCode = response.getStatus();
        String string = body = response.getBody() != null ? new String(response.getBody(), StandardCharsets.UTF_8) : "";
        if (statusCode >= 200 && statusCode < 300) {
            return TrustBundleResponse.fromJson(body);
        }
        ErrorResponse errorResponse = ErrorResponse.fromJson(body);
        if (errorResponse != null) {
            throw IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(statusCode), "Received error from hsm with status code " + statusCode + " and message " + errorResponse.getMessage());
        }
        throw IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(statusCode), "Received error from hsm with status code " + statusCode);
    }

    private HttpsResponse sendRequestBasedOnScheme(HttpsMethod httpsMethod, byte[] body, String baseUri, String path, String queryString) throws TransportException, IOException {
        HttpsResponse response;
        URL requestUrl;
        if (this.scheme.equalsIgnoreCase(HTTPS_SCHEME) || this.scheme.equalsIgnoreCase(HTTP_SCHEME)) {
            requestUrl = queryString != null && !queryString.isEmpty() ? new URL(baseUri + path + "?" + queryString) : new URL(baseUri + path);
        } else if (this.scheme.equalsIgnoreCase(UNIX_SCHEME)) {
            requestUrl = null;
        } else {
            throw new UnsupportedOperationException("unrecognized URI scheme. Only HTTPS, HTTP and UNIX are supported");
        }
        HttpsRequest httpsRequest = new HttpsRequest(requestUrl, httpsMethod, body, "");
        httpsRequest.setHeaderField("Accept", "application/json");
        if (body.length > 0) {
            httpsRequest.setHeaderField("Content-Type", "application/json");
        }
        if (this.scheme.equalsIgnoreCase(HTTPS_SCHEME)) {
            response = httpsRequest.send();
        } else if (this.scheme.equalsIgnoreCase(HTTP_SCHEME)) {
            response = httpsRequest.sendAsHttpRequest();
        } else if (this.scheme.equalsIgnoreCase(UNIX_SCHEME)) {
            if (this.unixDomainSocketChannel == null) {
                throw new IllegalArgumentException("Must provide an implementation of the UnixDomainSocketChannel interface since this edge runtime setup requires communicating over unix domain sockets.");
            }
            log.trace("User provided UnixDomainSocketChannel will be used for setup.");
            String unixAddressPrefix = "unix://";
            String localUnixSocketPath = baseUri.substring(baseUri.indexOf(unixAddressPrefix) + unixAddressPrefix.length());
            response = this.sendHttpRequestUsingUnixSocket(httpsRequest, path, queryString, localUnixSocketPath);
        } else {
            throw new UnsupportedOperationException("unrecognized URI scheme \"" + this.scheme + "\". Only HTTPS, HTTP and UNIX are supported");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsResponse sendHttpRequestUsingUnixSocket(HttpsRequest httpsRequest, String httpRequestPath, String httpRequestQueryString, String unixSocketAddress) throws IOException {
        HttpsResponse response;
        log.debug("Sending data over unix domain socket");
        try {
            byte[] requestBytes = HttpsRequestResponseSerializer.serializeRequest(httpsRequest, httpRequestPath, httpRequestQueryString, unixSocketAddress);
            this.unixDomainSocketChannel.open(unixSocketAddress);
            if (httpsRequest.getBody() != null) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    outputStream.write(requestBytes);
                    outputStream.write(httpsRequest.getBody());
                    byte[] output = outputStream.toByteArray();
                    log.trace("Writing {} bytes to unix domain socket", (Object)output.length);
                    log.trace("Contents of the request:\r\n{}", (Object)new String(output, StandardCharsets.UTF_8));
                    this.unixDomainSocketChannel.write(output);
                }
            } else {
                log.trace("Writing {} bytes to unix domain socket", (Object)requestBytes.length);
                log.trace("Contents of the request:\r\n{}", (Object)new String(requestBytes, StandardCharsets.UTF_8));
                this.unixDomainSocketChannel.write(requestBytes);
            }
            String responseString = this.readResponseFromChannel(this.unixDomainSocketChannel);
            response = HttpsRequestResponseSerializer.deserializeResponse(new BufferedReader(new StringReader(responseString)));
        }
        finally {
            log.trace("Closing unix domain socket");
            this.unixDomainSocketChannel.close();
        }
        return response;
    }

    private String readResponseFromChannel(UnixDomainSocketChannel channel) throws IOException {
        log.debug("Reading response from unix domain socket");
        byte[] buf = new byte[400];
        StringBuilder responseStringBuilder = new StringBuilder();
        int numRead = channel.read(buf);
        while (numRead >= 0) {
            log.trace("Read {} bytes from unix domain socket", (Object)numRead);
            String readChunk = new String(Arrays.copyOfRange(buf, 0, numRead), StandardCharsets.US_ASCII);
            log.trace("Read chunk of data from unix domain socket:");
            log.trace("{}", (Object)readChunk);
            responseStringBuilder.append(readChunk);
            numRead = channel.read(buf);
        }
        String response = responseStringBuilder.toString();
        log.debug("Read response from unix domain socket channel");
        log.debug("{}", (Object)response);
        return response;
    }
}

