/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;

public class IotHubTransportMessage
extends Message {
    private HttpsMethod iotHubMethod;
    private String uriPath;
    private String methodName;
    private Integer version;
    private String requestId;
    private String status;
    private DeviceOperations operationType;
    private MessageCallback messageCallback;
    private Object messageCallbackContext;
    private int qualityOfService;

    public IotHubTransportMessage(byte[] data, MessageType messageType) {
        super(data);
        super.setMessageType(messageType);
        this.methodName = null;
        this.version = null;
        this.requestId = null;
        this.status = null;
        this.operationType = DeviceOperations.DEVICE_OPERATION_UNKNOWN;
    }

    public IotHubTransportMessage(String body) {
        super(body);
        super.setMessageType(MessageType.UNKNOWN);
        this.methodName = null;
        this.version = null;
        this.requestId = null;
        this.status = null;
        this.operationType = DeviceOperations.DEVICE_OPERATION_UNKNOWN;
    }

    public IotHubTransportMessage(byte[] data, MessageType messageType, String messageId, String correlationId, MessageProperty[] messageProperties) {
        super(data);
        super.setMessageType(messageType);
        this.setMessageId(messageId);
        this.setCorrelationId(correlationId);
        for (MessageProperty messageProperty : messageProperties) {
            this.setProperty(messageProperty.getName(), messageProperty.getValue());
        }
    }

    public MessageCallback getMessageCallback() {
        return this.messageCallback;
    }

    public void setMessageCallback(MessageCallback messageCallback) {
        this.messageCallback = messageCallback;
    }

    public Object getMessageCallbackContext() {
        return this.messageCallbackContext;
    }

    public void setMessageCallbackContext(Object messageCallbackContext) {
        this.messageCallbackContext = messageCallbackContext;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setDeviceOperationType(DeviceOperations deviceOperationType) {
        this.operationType = deviceOperationType;
    }

    public DeviceOperations getDeviceOperationType() {
        return this.operationType;
    }

    public boolean isMessageAckNeeded(IotHubClientProtocol protocol) {
        if (protocol == IotHubClientProtocol.MQTT || protocol == IotHubClientProtocol.MQTT_WS) {
            return this.operationType != DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST && this.operationType != DeviceOperations.DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST && this.operationType != DeviceOperations.DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST;
        }
        return true;
    }

    public void setMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Method name cannot be null");
        }
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setIotHubMethod(HttpsMethod iotHubMethod) {
        this.iotHubMethod = iotHubMethod;
    }

    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    public HttpsMethod getIotHubMethod() {
        return this.iotHubMethod;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    @Override
    public String toString() {
        StringBuilder base = new StringBuilder(super.toString());
        if (this.requestId != null && !this.requestId.isEmpty()) {
            base.append("Request Id [").append(this.requestId).append("] ");
        }
        if (this.getDeviceOperationType() != null && this.getDeviceOperationType() != DeviceOperations.DEVICE_OPERATION_UNKNOWN) {
            base.append("Device Operation Type [").append((Object)this.getDeviceOperationType()).append("] ");
        }
        return base.toString();
    }

    public int getQualityOfService() {
        return this.qualityOfService;
    }

    public void setQualityOfService(int qualityOfService) {
        this.qualityOfService = qualityOfService;
    }
}

