/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryDecision {
    private static final Logger log = LoggerFactory.getLogger(RetryDecision.class);
    private final boolean shouldRetry;
    private final long duration;

    public RetryDecision(boolean shouldRetry, long duration) {
        this.duration = duration;
        this.shouldRetry = shouldRetry;
        if (!shouldRetry) {
            log.debug("NOTE: A new instance of RetryDecision has been created with retry disabled, the client will not perform any retries.");
        } else {
            log.debug("NOTE: A new instance of RetryDecision has been created with retry enabled, the client will retry after {} milliseconds", (Object)duration);
        }
    }

    public boolean shouldRetry() {
        return this.shouldRetry;
    }

    public long getDuration() {
        return this.duration;
    }
}

