/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendResult;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSenderLinkHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AmqpsCbsSenderLinkHandler
extends AmqpsSenderLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(AmqpsCbsSenderLinkHandler.class);
    private static final String SENDER_LINK_ENDPOINT_PATH = "$cbs";
    private static final String SENDER_LINK_TAG_PREFIX = "cbs-sender";
    private static final String CBS_TO = "$cbs";
    private static final String CBS_REPLY = "cbs";
    private static final String LINK_TYPE = "cbs";
    private static final String OPERATION_KEY = "operation";
    private static final String TYPE_KEY = "type";
    private static final String NAME_KEY = "name";
    private static final String OPERATION_VALUE = "put-token";
    private static final String TYPE_VALUE = "servicebus.windows.net:sastoken";
    private static final String DEVICES_PATH = "/devices/";

    AmqpsCbsSenderLinkHandler(Sender sender, AmqpsLinkStateCallback amqpsLinkStateCallback) {
        super(sender, amqpsLinkStateCallback, UUID.randomUUID().toString(), null);
        this.senderLinkAddress = "$cbs";
    }

    static String getCbsTag() {
        return SENDER_LINK_TAG_PREFIX;
    }

    @Override
    public String getLinkInstanceType() {
        return "cbs";
    }

    UUID sendAuthenticationMessage(ClientConfiguration clientConfiguration) throws TransportException {
        UUID correlationId = UUID.randomUUID();
        MessageImpl outgoingMessage = this.createCBSAuthenticationMessage(clientConfiguration, correlationId);
        AmqpsSendResult sendResult = this.sendMessageAndGetDeliveryTag(outgoingMessage);
        this.inProgressMessages.put(sendResult.getDeliveryTag(), new Message());
        return correlationId;
    }

    private MessageImpl createCBSAuthenticationMessage(ClientConfiguration clientConfiguration, UUID correlationId) throws TransportException {
        MessageImpl outgoingMessage = (MessageImpl)Proton.message();
        Properties properties = new Properties();
        properties.setMessageId((Object)correlationId);
        properties.setTo("$cbs");
        properties.setReplyTo("cbs");
        outgoingMessage.setProperties(properties);
        HashMap<String, String> userProperties = new HashMap<String, String>(3);
        userProperties.put(OPERATION_KEY, OPERATION_VALUE);
        userProperties.put(TYPE_KEY, TYPE_VALUE);
        String host = clientConfiguration.getGatewayHostname();
        if (host == null || host.isEmpty()) {
            host = clientConfiguration.getIotHubHostname();
        }
        userProperties.put(NAME_KEY, host + DEVICES_PATH + clientConfiguration.getDeviceId());
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        outgoingMessage.setApplicationProperties(applicationProperties);
        try {
            AmqpValue section = new AmqpValue((Object)String.valueOf(clientConfiguration.getSasTokenAuthentication().getSasToken()));
            outgoingMessage.setBody((Section)section);
        }
        catch (IOException e) {
            log.error("Failed to renew sas token while building new cbs authentication message", (Throwable)e);
            throw new TransportException(e);
        }
        return outgoingMessage;
    }
}

