/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.edge.DirectMethodRequest;
import com.microsoft.azure.sdk.iot.device.edge.DirectMethodResponse;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsIotHubConnection;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.IotHubUri;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpsTransportManager {
    private final ClientConfiguration config;
    private HttpsIotHubConnection httpsIotHubConnection;
    private static final String MODULE_ID = "x-ms-edge-moduleId";
    private static final String ModuleMethodUriFormat = "/twins/%s/modules/%s/methods";
    private static final String DeviceMethodUriFormat = "/twins/%s/methods";
    private static final String PATH_NOTIFICATIONS_STRING = "/files/notifications";
    private static final String PATH_FILES_STRING = "/files";

    public HttpsTransportManager(ClientConfiguration config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
        this.httpsIotHubConnection = new HttpsIotHubConnection(config);
    }

    public HttpsResponse getFileUploadSasUri(IotHubTransportMessage message) throws IOException {
        String uri = new IotHubUri("", this.config.getDeviceId(), PATH_FILES_STRING, this.config.getModuleId()).toStringWithoutApiVersion();
        message.setUriPath(uri);
        return this.send(message, new HashMap<String, String>());
    }

    public HttpsResponse sendFileUploadNotification(IotHubTransportMessage message) throws IOException {
        String uri = new IotHubUri("", this.config.getDeviceId(), PATH_NOTIFICATIONS_STRING, this.config.getModuleId()).toStringWithoutApiVersion();
        message.setUriPath(uri);
        return this.send(message, new HashMap<String, String>());
    }

    public HttpsResponse send(IotHubTransportMessage message, Map<String, String> additionalHeaders) throws IOException, IllegalArgumentException {
        HttpsMethod httpsMethod;
        HttpsSingleMessage httpsMessage = HttpsSingleMessage.parseHttpsJsonMessage(message);
        if (message.getIotHubMethod() == null || message.getUriPath() == null) {
            throw new IllegalArgumentException("method or path is null");
        }
        switch (message.getIotHubMethod()) {
            case GET: {
                httpsMethod = HttpsMethod.GET;
                break;
            }
            case POST: {
                httpsMethod = HttpsMethod.POST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IoT Hub type " + message.getIotHubMethod().toString());
            }
        }
        String httpsPath = message.getUriPath();
        try {
            return this.httpsIotHubConnection.sendHttpsMessage(httpsMessage, httpsMethod, httpsPath, additionalHeaders);
        }
        catch (TransportException e) {
            throw new IOException(e);
        }
    }

    public Message receive() throws IOException {
        try {
            return this.httpsIotHubConnection.receiveMessage();
        }
        catch (TransportException e) {
            throw new IOException(e);
        }
    }

    public DirectMethodResponse invokeMethod(DirectMethodRequest directMethodRequest, String deviceId, String moduleId) throws IOException, TransportException {
        String path = moduleId == null || moduleId.isEmpty() ? HttpsTransportManager.getDirectMethodPath(deviceId) : HttpsTransportManager.getModuleMethodPath(deviceId, moduleId);
        return this.invokeMethod(directMethodRequest, path);
    }

    private DirectMethodResponse invokeMethod(DirectMethodRequest directMethodRequest, String path) throws IOException, TransportException {
        if (directMethodRequest == null) {
            throw new IllegalArgumentException("direct method request cannot be null");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be null or be an empty path");
        }
        IotHubTransportMessage message = new IotHubTransportMessage(directMethodRequest.toJson());
        message.setIotHubMethod(HttpsMethod.POST);
        message.setUriPath(path);
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put(MODULE_ID, this.config.getDeviceId() + "/" + this.config.getModuleId());
        HttpsResponse responseMessage = this.send(message, additionalHeaders);
        if (responseMessage.getStatus() != 200 && responseMessage.getStatus() != 204) {
            throw IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(responseMessage.getStatus()), new String(responseMessage.getBody(), StandardCharsets.UTF_8));
        }
        String resultJson = new String(responseMessage.getBody(), StandardCharsets.UTF_8);
        return new DirectMethodResponse(resultJson);
    }

    private static String getDirectMethodPath(String deviceId) throws UnsupportedEncodingException {
        deviceId = URLEncoder.encode(deviceId, StandardCharsets.UTF_8.name());
        return String.format(DeviceMethodUriFormat, deviceId);
    }

    private static String getModuleMethodPath(String deviceId, String moduleId) throws UnsupportedEncodingException {
        deviceId = URLEncoder.encode(deviceId, StandardCharsets.UTF_8.name());
        moduleId = URLEncoder.encode(moduleId, StandardCharsets.UTF_8.name());
        return String.format(ModuleMethodUriFormat, deviceId, moduleId);
    }
}

