/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.twin;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.microsoft.azure.sdk.iot.device.ClientConfiguration;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageSentCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.twin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.twin.DirectMethodPayload;
import com.microsoft.azure.sdk.iot.device.twin.DirectMethodResponse;
import com.microsoft.azure.sdk.iot.device.twin.MethodCallback;
import com.microsoft.azure.sdk.iot.device.twin.MethodParser;
import com.microsoft.azure.sdk.iot.device.twin.SubscriptionAcknowledgedCallback;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectMethod {
    private static final Logger log = LoggerFactory.getLogger(DirectMethod.class);
    private MethodCallback methodCallback;
    private Object deviceMethodCallbackContext;
    private final MessageSentCallback deviceMethodStatusCallback;
    private final Object deviceMethodStatusCallbackContext;
    private final Object DEVICE_METHOD_LOCK = new Object();
    private boolean isSubscribed = false;
    private final InternalClient client;
    private final ClientConfiguration config;

    public DirectMethod(InternalClient client, final SubscriptionAcknowledgedCallback deviceMethodStatusCallback, Object deviceMethodStatusCallbackContext) throws IllegalArgumentException {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (deviceMethodStatusCallback == null) {
            throw new IllegalArgumentException("Status call back cannot be null");
        }
        this.client = client;
        this.config = client.getConfig();
        this.deviceMethodStatusCallback = new MessageSentCallback(){

            @Override
            public void onMessageSent(Message sentMessage, IotHubClientException clientException, Object callbackContext) {
                deviceMethodStatusCallback.onSubscriptionAcknowledged(clientException, callbackContext);
            }
        };
        this.deviceMethodStatusCallbackContext = deviceMethodStatusCallbackContext;
        this.config.setDirectMethodsMessageCallback(new DirectMethodResponseCallback(), null);
    }

    public void subscribeToDirectMethods(MethodCallback methodCallback, Object deviceMethodCallbackContext) throws IllegalArgumentException {
        if (methodCallback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.methodCallback = methodCallback;
        this.deviceMethodCallbackContext = deviceMethodCallbackContext;
        if (!this.isSubscribed) {
            IotHubTransportMessage subscribeMessage = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_METHODS);
            subscribeMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST);
            subscribeMessage.setConnectionDeviceId(this.config.getDeviceId());
            this.client.sendEventAsync(subscribeMessage, new DirectMethodRequestMessageCallback(), null);
        }
    }

    private final class DirectMethodRequestMessageCallback
    implements MessageSentCallback {
        private DirectMethodRequestMessageCallback() {
        }

        @Override
        public void onMessageSent(Message sentMessage, IotHubClientException exception, Object callbackContext) {
            DirectMethod.this.deviceMethodStatusCallback.onMessageSent(sentMessage, exception, DirectMethod.this.deviceMethodStatusCallbackContext);
        }
    }

    private final class DirectMethodResponseCallback
    implements MessageCallback {
        final ClientConfiguration nestedConfig;

        private DirectMethodResponseCallback() {
            this.nestedConfig = DirectMethod.this.config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IotHubMessageResult onCloudToDeviceMessageReceived(Message message, Object callbackContext) {
            Object object = DirectMethod.this.DEVICE_METHOD_LOCK;
            synchronized (object) {
                IotHubMessageResult result;
                block12: {
                    IotHubStatusCode iotHubStatus = IotHubStatusCode.ERROR;
                    result = IotHubMessageResult.ABANDON;
                    if (message.getMessageType() != MessageType.DEVICE_METHODS) {
                        log.error("Unexpected message type received {}", (Object)message.getMessageType());
                        DirectMethod.this.deviceMethodStatusCallback.onMessageSent(message, IotHubStatusCode.toException(iotHubStatus), DirectMethod.this.deviceMethodStatusCallbackContext);
                        return IotHubMessageResult.ABANDON;
                    }
                    IotHubTransportMessage methodMessage = (IotHubTransportMessage)message;
                    if (methodMessage.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_METHOD_RECEIVE_REQUEST) {
                        if (DirectMethod.this.methodCallback != null) {
                            if (!DirectMethod.this.isSubscribed) {
                                DirectMethod.this.isSubscribed = true;
                            }
                            try {
                                log.trace("Executing method invocation callback for method name {} for message {}", (Object)methodMessage.getMethodName(), (Object)methodMessage);
                                MethodParser methodParser = new MethodParser();
                                JsonElement jsonElement = methodParser.getPayloadFromJson(new String(methodMessage.getBytes(), StandardCharsets.UTF_8));
                                DirectMethodResponse responseData = DirectMethod.this.methodCallback.onMethodInvoked(methodMessage.getMethodName(), new DirectMethodPayload(jsonElement), DirectMethod.this.deviceMethodCallbackContext);
                                log.trace("Method invocation callback returned for method name {} for message {}", (Object)methodMessage.getMethodName(), (Object)methodMessage);
                                if (responseData != null) {
                                    JsonElement payload = new GsonBuilder().create().toJsonTree(responseData.getPayload());
                                    MethodParser methodParserObject = new MethodParser(payload);
                                    IotHubTransportMessage responseMessage = new IotHubTransportMessage(methodParserObject.toJson().getBytes(StandardCharsets.UTF_8), MessageType.DEVICE_METHODS);
                                    responseMessage.setRequestId(methodMessage.getRequestId());
                                    responseMessage.setConnectionDeviceId(this.nestedConfig.getDeviceId());
                                    responseMessage.setStatus(String.valueOf(responseData.getStatus()));
                                    responseMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_METHOD_SEND_RESPONSE);
                                    DirectMethod.this.client.sendEventAsync(responseMessage, new DirectMethodRequestMessageCallback(), null);
                                    result = IotHubMessageResult.COMPLETE;
                                    break block12;
                                }
                                log.info("User callback did not send any data for response");
                                result = IotHubMessageResult.REJECT;
                                DirectMethod.this.deviceMethodStatusCallback.onMessageSent(message, IotHubStatusCode.toException(iotHubStatus), DirectMethod.this.deviceMethodStatusCallbackContext);
                            }
                            catch (Exception e) {
                                log.info("User callback did not succeed");
                                result = IotHubMessageResult.REJECT;
                                DirectMethod.this.deviceMethodStatusCallback.onMessageSent(message, IotHubStatusCode.toException(iotHubStatus), DirectMethod.this.deviceMethodStatusCallbackContext);
                            }
                        } else {
                            log.warn("Received device method request, but device has not setup device method");
                        }
                    } else {
                        log.warn("Received unknown type message for device methods");
                    }
                }
                return result;
            }
        }
    }
}

