/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.twin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.device.twin.Tools;
import com.microsoft.azure.sdk.iot.device.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.device.twin.TwinGsonBuilder;
import com.microsoft.azure.sdk.iot.device.twin.TwinProperties;

public class Twin {
    private static final String PROPERTIES_TAG = "properties";
    @Expose(serialize=false)
    @SerializedName(value="properties")
    private TwinProperties properties;

    public Twin(TwinCollection desiredProperty, TwinCollection reportedProperty) {
        if (desiredProperty != null || reportedProperty != null) {
            this.properties = new TwinProperties(desiredProperty, reportedProperty);
        }
    }

    public JsonElement toJsonElement() {
        Gson gson = TwinGsonBuilder.getGson();
        JsonObject json = gson.toJsonTree((Object)this).getAsJsonObject();
        if (json != null && this.properties != null) {
            json.getAsJsonObject().add(PROPERTIES_TAG, this.properties.toJsonElement());
        }
        return json;
    }

    public TwinCollection getDesiredProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getDesired();
    }

    public TwinCollection getReportedProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getReported();
    }

    public String toString() {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject jsonObject = gson.toJsonTree((Object)this).getAsJsonObject();
        if (this.properties != null) {
            jsonObject.add(PROPERTIES_TAG, this.properties.toJsonElementWithMetadata());
        }
        return jsonObject.toString();
    }

    public static Twin createFromTwinJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        Twin result = (Twin)gson.fromJson(json, Twin.class);
        if (result.properties != null) {
            result.properties = new TwinProperties(result.properties.getDesired(), result.properties.getReported());
        }
        return result;
    }

    public static Twin createFromDesiredPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new Twin(result, null);
    }

    public static Twin createFromReportedPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new Twin(null, result);
    }

    public static Twin createFromPropertiesJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinProperties result = (TwinProperties)gson.fromJson(json, TwinProperties.class);
        return new Twin(result.getDesired(), result.getReported());
    }

    Twin() {
    }
}

