/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationParser;
import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationTypeParser;
import com.microsoft.azure.sdk.iot.deps.serializer.DeviceParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.SymmetricKeyParser;
import com.microsoft.azure.sdk.iot.deps.serializer.X509ThumbprintParser;
import com.microsoft.azure.sdk.iot.service.DeviceConnectionState;
import com.microsoft.azure.sdk.iot.service.DeviceStatus;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationMechanism;
import com.microsoft.azure.sdk.iot.service.auth.AuthenticationType;
import com.microsoft.azure.sdk.iot.service.auth.SymmetricKey;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class Device {
    protected final String UTC_TIME_DEFAULT = "0001-01-01T00:00:00";
    protected final String OFFSET_TIME_DEFAULT = "0001-01-01T00:00:00-00:00";
    protected String deviceId;
    protected String generationId;
    protected String eTag;
    protected DeviceStatus status;
    protected String statusReason;
    protected String statusUpdatedTime;
    protected DeviceConnectionState connectionState;
    protected String connectionStateUpdatedTime;
    protected String lastActivityTime;
    protected long cloudToDeviceMessageCount;
    private Boolean forceUpdate;
    AuthenticationMechanism authentication;

    public static Device createFromId(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws IllegalArgumentException, NoSuchAlgorithmException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException(deviceId);
        }
        return new Device(deviceId, status, symmetricKey);
    }

    public static Device createDevice(String deviceId, AuthenticationType authenticationType) {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("The provided authentication type must not be null");
        }
        return new Device(deviceId, authenticationType);
    }

    protected Device(String deviceId, DeviceStatus status, SymmetricKey symmetricKey) throws NoSuchAlgorithmException, IllegalArgumentException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("Device Id cannot be null or empty.");
        }
        this.authentication = symmetricKey == null ? new AuthenticationMechanism(AuthenticationType.SAS) : new AuthenticationMechanism(symmetricKey);
        this.setPropertiesToDefaultValues();
        this.deviceId = deviceId;
        this.status = status != null ? status : DeviceStatus.Enabled;
    }

    private Device(String deviceId, AuthenticationType authenticationType) {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("The provided device Id must not be null or empty");
        }
        if (authenticationType == null) {
            throw new IllegalArgumentException("The provided authentication type must not be null");
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.setPropertiesToDefaultValues();
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public SymmetricKey getSymmetricKey() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSymmetricKey();
    }

    public void setSymmetricKey(SymmetricKey symmetricKey) throws IllegalArgumentException {
        if (symmetricKey == null) {
            throw new IllegalArgumentException("Symmetric key cannot be null");
        }
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(symmetricKey);
        } else {
            this.authentication.setSymmetricKey(symmetricKey);
        }
    }

    public String getPrimaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getPrimaryKey();
    }

    public String getSecondaryKey() {
        if (this.getSymmetricKey() == null) {
            return null;
        }
        return this.getSymmetricKey().getSecondaryKey();
    }

    public void setThumbprint(String primaryThumbprint, String secondaryThumbprint) {
        if (Tools.isNullOrEmpty(primaryThumbprint).booleanValue() || Tools.isNullOrEmpty(secondaryThumbprint).booleanValue()) {
            throw new IllegalArgumentException("Thumbprint may not be null or empty");
        }
        if (this.authentication == null) {
            this.authentication = new AuthenticationMechanism(AuthenticationType.SELF_SIGNED);
        }
        this.authentication.setPrimaryThumbprint(primaryThumbprint);
        this.authentication.setSecondaryThumbprint(secondaryThumbprint);
    }

    public String getPrimaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getPrimaryThumbprint();
    }

    public String getSecondaryThumbprint() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getSecondaryThumbprint();
    }

    public String geteTag() {
        return this.eTag;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeviceStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public DeviceConnectionState getConnectionState() {
        return this.connectionState;
    }

    public String getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setForceUpdate(Boolean forceUpdate) throws IllegalArgumentException {
        if (forceUpdate == null) {
            throw new IllegalArgumentException();
        }
        this.forceUpdate = forceUpdate;
    }

    public AuthenticationType getAuthenticationType() {
        if (this.authentication == null) {
            return null;
        }
        return this.authentication.getAuthenticationType();
    }

    DeviceParser toDeviceParser() {
        DeviceParser deviceParser = new DeviceParser();
        deviceParser.setCloudToDeviceMessageCount(this.cloudToDeviceMessageCount);
        deviceParser.setConnectionState(this.connectionState.toString());
        deviceParser.setConnectionStateUpdatedTime(ParserUtility.getDateTimeUtc((String)this.connectionStateUpdatedTime));
        deviceParser.setDeviceId(this.deviceId);
        deviceParser.seteTag(this.eTag);
        deviceParser.setLastActivityTime(ParserUtility.getDateTimeUtc((String)this.lastActivityTime));
        deviceParser.setGenerationId(this.generationId);
        deviceParser.setStatus(this.status.toString());
        deviceParser.setStatusReason(this.statusReason);
        deviceParser.setStatusUpdatedTime(ParserUtility.getDateTimeUtc((String)this.statusUpdatedTime));
        deviceParser.setAuthenticationParser(new AuthenticationParser());
        deviceParser.getAuthenticationParser().setType(AuthenticationTypeParser.valueOf((String)this.authentication.getAuthenticationType().toString()));
        if (this.authentication.getAuthenticationType() != AuthenticationType.CERTIFICATE_AUTHORITY) {
            if (this.authentication.getAuthenticationType() == AuthenticationType.SELF_SIGNED) {
                if (Tools.isNullOrEmpty(this.authentication.getPrimaryThumbprint()).booleanValue() || Tools.isNullOrEmpty(this.authentication.getSecondaryThumbprint()).booleanValue()) {
                    throw new IllegalStateException("Device object using self signed authentication needs to have both primary and secondary thumbprints");
                }
                deviceParser.getAuthenticationParser().setThumbprint(new X509ThumbprintParser(this.getPrimaryThumbprint(), this.getSecondaryThumbprint()));
            } else if (this.authentication.getAuthenticationType() == AuthenticationType.SAS) {
                if (this.authentication.getSymmetricKey() == null || Tools.isNullOrEmpty(this.authentication.getSymmetricKey().getPrimaryKey()).booleanValue() || Tools.isNullOrEmpty(this.authentication.getSymmetricKey().getSecondaryKey()).booleanValue()) {
                    throw new IllegalStateException("Device object using SAS authentication needs to have both primary and secondary keys");
                }
                deviceParser.getAuthenticationParser().setSymmetricKey(new SymmetricKeyParser(this.getPrimaryKey(), this.getSecondaryKey()));
            }
        }
        return deviceParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Device(DeviceParser parser) throws IllegalArgumentException {
        if (parser.getAuthenticationParser() == null || parser.getAuthenticationParser().getType() == null) {
            throw new IllegalArgumentException("deviceParser must have an authentication type assigned");
        }
        if (parser.getDeviceId() == null) {
            throw new IllegalArgumentException("deviceParser must have a deviceId assigned");
        }
        AuthenticationType authenticationType = AuthenticationType.valueOf(parser.getAuthenticationParser().getType().toString());
        this.deviceId = parser.getDeviceId();
        this.authentication = new AuthenticationMechanism(authenticationType);
        this.cloudToDeviceMessageCount = parser.getCloudToDeviceMessageCount();
        this.deviceId = parser.getDeviceId();
        this.eTag = parser.geteTag();
        this.generationId = parser.getGenerationId();
        this.statusReason = parser.getStatusReason();
        if (parser.getConnectionStateUpdatedTime() != null) {
            this.connectionStateUpdatedTime = ParserUtility.getDateStringFromDate((Date)parser.getConnectionStateUpdatedTime());
        }
        if (parser.getStatusUpdatedTime() != null) {
            this.statusUpdatedTime = ParserUtility.getDateStringFromDate((Date)parser.getStatusUpdatedTime());
        }
        if (parser.getLastActivityTime() != null) {
            this.lastActivityTime = ParserUtility.getDateStringFromDate((Date)parser.getLastActivityTime());
        }
        if (parser.getStatus() != null) {
            this.status = DeviceStatus.fromString(parser.getStatus());
        }
        if (parser.getConnectionState() != null) {
            this.connectionState = DeviceConnectionState.valueOf(parser.getConnectionState());
        }
        this.authentication = new AuthenticationMechanism(authenticationType);
        if (authenticationType == AuthenticationType.CERTIFICATE_AUTHORITY) return;
        if (authenticationType == AuthenticationType.SELF_SIGNED) {
            if (parser.getAuthenticationParser().getThumbprint() == null || parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprint() == null || parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprint() == null) throw new IllegalArgumentException("AuthenticationParser object in the provided DeviceParser object is missing one or more thumbprint values");
            this.setThumbprint(parser.getAuthenticationParser().getThumbprint().getPrimaryThumbprint(), parser.getAuthenticationParser().getThumbprint().getSecondaryThumbprint());
            return;
        } else {
            if (authenticationType != AuthenticationType.SAS) return;
            if (parser.getAuthenticationParser().getSymmetricKey() == null || parser.getAuthenticationParser().getSymmetricKey().getPrimaryKey() == null || parser.getAuthenticationParser().getSymmetricKey().getSecondaryKey() == null) throw new IllegalArgumentException("AuthenticationParser object in the provided DeviceParser object is missing one or more symmetric keys");
            this.getSymmetricKey().setPrimaryKey(parser.getAuthenticationParser().getSymmetricKey().getPrimaryKey());
            this.getSymmetricKey().setSecondaryKey(parser.getAuthenticationParser().getSymmetricKey().getSecondaryKey());
        }
    }

    private void setPropertiesToDefaultValues() {
        this.status = DeviceStatus.Enabled;
        this.generationId = "";
        this.eTag = "";
        this.statusReason = "";
        this.statusUpdatedTime = "0001-01-01T00:00:00";
        this.connectionState = DeviceConnectionState.Disconnected;
        this.connectionStateUpdatedTime = "0001-01-01T00:00:00";
        this.lastActivityTime = "0001-01-01T00:00:00-00:00";
        this.cloudToDeviceMessageCount = 0L;
        this.setForceUpdate(false);
    }
}

