/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.FeedbackBatch;
import com.microsoft.azure.sdk.iot.service.FeedbackRecord;
import com.microsoft.azure.sdk.iot.service.FeedbackStatusCode;
import com.microsoft.azure.sdk.iot.service.Tools;
import java.io.Reader;
import java.io.StringReader;
import java.time.Instant;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class FeedbackBatchMessage {
    public static FeedbackBatch parse(String jsonString) {
        FeedbackBatch returnFeedbackBatch = new FeedbackBatch();
        if (!Tools.isNullOrEmpty(jsonString).booleanValue()) {
            if (jsonString.startsWith("Data{")) {
                jsonString = jsonString.substring(5, jsonString.length() - 1);
            }
            if (!jsonString.equals("")) {
                try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
                    JsonArray jsonArray = jsonReader.readArray();
                    ArrayList<FeedbackRecord> records = new ArrayList<FeedbackRecord>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                        FeedbackRecord feedbackRecord = new FeedbackRecord();
                        feedbackRecord.setEnqueuedTimeUtc(Instant.parse(Tools.getValueFromJsonObject(jsonObject, "enqueuedTimeUtc")));
                        String originalMessageId = Tools.getValueFromJsonObject(jsonObject, "originalMessageId");
                        feedbackRecord.setOriginalMessageId(originalMessageId);
                        feedbackRecord.setCorrelationId("");
                        String description = Tools.getValueFromJsonObject(jsonObject, "description");
                        feedbackRecord.setDescription(description);
                        String statusCode = Tools.getValueFromJsonObject(jsonObject, "statusCode");
                        if (statusCode.toLowerCase().equals("success")) {
                            feedbackRecord.setStatusCode(FeedbackStatusCode.success);
                        } else if (statusCode.toLowerCase().equals("expired")) {
                            feedbackRecord.setStatusCode(FeedbackStatusCode.expired);
                        } else if (statusCode.toLowerCase().equals("deliverycountexceeded")) {
                            feedbackRecord.setStatusCode(FeedbackStatusCode.deliveryCountExceeded);
                        } else if (statusCode.toLowerCase().equals("rejected")) {
                            feedbackRecord.setStatusCode(FeedbackStatusCode.rejected);
                        } else {
                            feedbackRecord.setStatusCode(FeedbackStatusCode.unknown);
                        }
                        feedbackRecord.setDeviceId(Tools.getValueFromJsonObject(jsonObject, "deviceId"));
                        feedbackRecord.setDeviceGenerationId(Tools.getValueFromJsonObject(jsonObject, "deviceGenerationId"));
                        records.add(feedbackRecord);
                    }
                    if (records.size() > 0) {
                        returnFeedbackBatch.setEnqueuedTimeUtc(((FeedbackRecord)records.get(records.size() - 1)).getEnqueuedTimeUtc());
                        returnFeedbackBatch.setUserId("");
                        returnFeedbackBatch.setLockToken("");
                        returnFeedbackBatch.setRecords(records);
                    }
                }
            }
        }
        return returnFeedbackBatch;
    }
}

