/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.service.DeliveryAcknowledgement;
import com.microsoft.azure.sdk.iot.service.FeedbackStatusCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Message {
    private String deliveryAcknowledgementPropertyName = "iothub-ack";
    private String messageId;
    private String to;
    private Date expiryTimeUtc;
    private String lockToken;
    public String correlationId;
    private String userId;
    private Boolean httpBatchSerializeAsString;
    private StandardCharsets httpBatchEncoding;
    private String connectionDeviceId;
    private String connectionDeviceGenerationId;
    private String connectionAuthenticationMethod;
    private FeedbackStatusCode feedbackStatusCode;
    private String feedbackDescription;
    private String feedbackDeviceId;
    private String feedbackDeviceGenerationId;
    private DeliveryAcknowledgement deliveryAcknowledgement;
    private Map<String, String> properties = new HashMap<String, String>(1);
    private byte[] body;

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String deviceId) {
        this.to = "/devices/" + deviceId + "/messages/devicebound";
    }

    public Date getExpiryTimeUtc() {
        return this.expiryTimeUtc;
    }

    public void setExpiryTimeUtc(Date expiryTimeUtc) {
        this.expiryTimeUtc = expiryTimeUtc;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Message() {
        this.setDeliveryAcknowledgement(DeliveryAcknowledgement.Full);
    }

    public Message(ByteArrayInputStream stream) {
        this();
        if (stream != null) {
            this.body = stream.toString().getBytes();
        }
    }

    public Message(byte[] byteArray) {
        this();
        this.body = byteArray;
    }

    public Message(String string) throws UnsupportedEncodingException {
        this();
        this.body = string.getBytes(StandardCharsets.UTF_8);
    }

    public ByteArrayOutputStream getBodyStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.body.length);
        byteArrayOutputStream.write(this.body, 0, this.body.length);
        return byteArrayOutputStream;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public DeliveryAcknowledgement getDeliveryAcknowledgement() {
        return this.deliveryAcknowledgement;
    }

    public void setDeliveryAcknowledgement(DeliveryAcknowledgement deliveryAcknowledgement) {
        this.deliveryAcknowledgement = deliveryAcknowledgement;
        this.properties.put(this.deliveryAcknowledgementPropertyName, deliveryAcknowledgement.name().toLowerCase());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public void clearCustomProperties() {
        this.properties.clear();
        this.setDeliveryAcknowledgement(this.deliveryAcknowledgement);
    }
}

