/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.google.gson.JsonSyntaxException;
import com.microsoft.azure.sdk.iot.deps.serializer.DeviceParser;
import com.microsoft.azure.sdk.iot.deps.serializer.JobPropertiesParser;
import com.microsoft.azure.sdk.iot.deps.serializer.RegistryStatisticsParser;
import com.microsoft.azure.sdk.iot.service.Device;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.service.IotHubConnectionStringBuilder;
import com.microsoft.azure.sdk.iot.service.JobProperties;
import com.microsoft.azure.sdk.iot.service.RegistryStatistics;
import com.microsoft.azure.sdk.iot.service.Tools;
import com.microsoft.azure.sdk.iot.service.auth.IotHubServiceSasToken;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubExceptionManager;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpRequest;
import com.microsoft.azure.sdk.iot.service.transport.http.HttpResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class RegistryManager {
    private final Integer DEFAULT_HTTP_TIMEOUT_MS = 24000;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private IotHubConnectionString iotHubConnectionString;

    public static RegistryManager createFromConnectionString(String connectionString) throws IOException {
        if (Tools.isNullOrEmpty(connectionString).booleanValue()) {
            throw new IllegalArgumentException("The provided connection string cannot be null or empty");
        }
        IotHubConnectionString iotHubConnectionString = IotHubConnectionStringBuilder.createConnectionString(connectionString);
        RegistryManager iotHubRegistryManager = new RegistryManager();
        iotHubRegistryManager.iotHubConnectionString = iotHubConnectionString;
        return iotHubRegistryManager;
    }

    public void open() {
    }

    public void close() {
    }

    public Device addDevice(Device device) throws IOException, IotHubException, JsonSyntaxException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        String deviceJson = device.toDeviceParser().toJson();
        URL url = this.iotHubConnectionString.getUrlDevice(device.getDeviceId());
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.PUT, deviceJson.getBytes(), sasTokenString);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        Device iotHubDevice = new Device(new DeviceParser(bodyStr));
        return iotHubDevice;
    }

    public CompletableFuture<Device> addDeviceAsync(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        CompletableFuture<Device> future = new CompletableFuture<Device>();
        this.executor.submit(() -> {
            try {
                Device responseDevice = this.addDevice(device);
                future.complete(responseDevice);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public Device getDevice(String deviceId) throws IOException, IotHubException, JsonSyntaxException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        URL url = this.iotHubConnectionString.getUrlDevice(deviceId);
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.GET, new byte[0], sasTokenString);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        Device iotHubDevice = new Device(new DeviceParser(bodyStr));
        return iotHubDevice;
    }

    public CompletableFuture<Device> getDeviceAsync(String deviceId) throws IOException, IotHubException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        CompletableFuture<Device> future = new CompletableFuture<Device>();
        this.executor.submit(() -> {
            try {
                Device responseDevice = this.getDevice(deviceId);
                future.complete(responseDevice);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public ArrayList<Device> getDevices(Integer maxCount) throws IOException, IotHubException, JsonSyntaxException {
        if (maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be less then 1");
        }
        URL url = this.iotHubConnectionString.getUrlDeviceList(maxCount);
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.GET, new byte[0], sasTokenString);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(bodyStr));){
            ArrayList<Device> deviceList = new ArrayList<Device>();
            JsonArray deviceArray = jsonReader.readArray();
            for (int i = 0; i < deviceArray.size(); ++i) {
                JsonObject jsonObject = deviceArray.getJsonObject(i);
                Device iotHubDevice = new Device(new DeviceParser(jsonObject.toString()));
                deviceList.add(iotHubDevice);
            }
            ArrayList<Device> arrayList = deviceList;
            return arrayList;
        }
    }

    public CompletableFuture<ArrayList<Device>> getDevicesAsync(Integer maxCount) throws IOException, IotHubException {
        if (maxCount < 1) {
            throw new IllegalArgumentException("maxCount cannot be less then 1");
        }
        CompletableFuture<ArrayList<Device>> future = new CompletableFuture<ArrayList<Device>>();
        this.executor.submit(() -> {
            try {
                ArrayList<Device> response = this.getDevices(maxCount);
                future.complete(response);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public String getDeviceConnectionString(Device device) {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        if (Tools.isNullOrEmpty(device.getDeviceId()).booleanValue() || Tools.isNullOrEmpty(device.getPrimaryKey()).booleanValue() && Tools.isNullOrEmpty(device.getPrimaryThumbprint()).booleanValue()) {
            throw new IllegalArgumentException("device is not valid");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("HostName=%s;", this.iotHubConnectionString.getHostName()));
        stringBuilder.append(String.format("DeviceId=%s;", device.getDeviceId()));
        if (device.getPrimaryKey() == null) {
            stringBuilder.append("x509=true");
        } else {
            stringBuilder.append(String.format("SharedAccessKey=%s", device.getPrimaryKey()));
        }
        return stringBuilder.toString();
    }

    public Device updateDevice(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        return this.updateDevice(device, false);
    }

    public Device updateDevice(Device device, Boolean forceUpdate) throws IOException, IotHubException, JsonSyntaxException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        device.setForceUpdate(forceUpdate);
        URL url = this.iotHubConnectionString.getUrlDevice(device.getDeviceId());
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.PUT, device.toDeviceParser().toJson().getBytes(), sasTokenString);
        request.setHeaderField("If-Match", "*");
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        Device iotHubDevice = new Device(new DeviceParser(bodyStr));
        return iotHubDevice;
    }

    public CompletableFuture<Device> updateDeviceAsync(Device device) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        CompletableFuture<Device> future = new CompletableFuture<Device>();
        this.executor.submit(() -> {
            try {
                Device responseDevice = this.updateDevice(device);
                future.complete(responseDevice);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Device> updateDeviceAsync(Device device, Boolean forceUpdate) throws IOException, IotHubException {
        if (device == null) {
            throw new IllegalArgumentException("device cannot be null");
        }
        CompletableFuture<Device> future = new CompletableFuture<Device>();
        this.executor.submit(() -> {
            try {
                Device responseDevice = this.updateDevice(device, forceUpdate);
                future.complete(responseDevice);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void removeDevice(String deviceId) throws IOException, IotHubException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        URL url = this.iotHubConnectionString.getUrlDevice(deviceId);
        String sasToken = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = new HttpRequest(url, HttpMethod.DELETE, new byte[0]);
        request.setReadTimeoutMillis(this.DEFAULT_HTTP_TIMEOUT_MS);
        request.setHeaderField("authorization", sasToken);
        request.setHeaderField("If-Match", "*");
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
    }

    public CompletableFuture<Boolean> removeDeviceAsync(String deviceId) throws IOException, IotHubException {
        if (Tools.isNullOrEmpty(deviceId).booleanValue()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.executor.submit(() -> {
            try {
                this.removeDevice(deviceId);
                future.complete(true);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public RegistryStatistics getStatistics() throws IOException, IotHubException, JsonSyntaxException {
        URL url = this.iotHubConnectionString.getUrlDeviceStatistics();
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.GET, new byte[0], sasTokenString);
        HttpResponse response = request.send();
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        RegistryStatistics registryStatistics = new RegistryStatistics(new RegistryStatisticsParser(bodyStr));
        return registryStatistics;
    }

    public CompletableFuture<RegistryStatistics> getStatisticsAsync() throws IOException, IotHubException {
        CompletableFuture<RegistryStatistics> future = new CompletableFuture<RegistryStatistics>();
        this.executor.submit(() -> {
            try {
                RegistryStatistics responseDevice = this.getStatistics();
                future.complete(responseDevice);
            }
            catch (IotHubException | IOException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public JobProperties exportDevices(String exportBlobContainerUri, Boolean excludeKeys) throws IllegalArgumentException, IOException, IotHubException, JsonSyntaxException {
        if (exportBlobContainerUri == null || excludeKeys == null) {
            throw new IllegalArgumentException("Export blob uri cannot be null");
        }
        URL url = this.iotHubConnectionString.getUrlCreateExportImportJob();
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        String jobPropertiesJson = this.CreateExportJobPropertiesJson(exportBlobContainerUri, excludeKeys);
        HttpRequest request = this.CreateRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(), sasTokenString);
        HttpResponse response = request.send();
        return this.ProcessJobResponse(response);
    }

    public CompletableFuture<JobProperties> exportDevicesAsync(String exportBlobContainerUri, Boolean excludeKeys) throws IllegalArgumentException, IOException, IotHubException, JsonSyntaxException {
        CompletableFuture<JobProperties> future = new CompletableFuture<JobProperties>();
        this.executor.submit(() -> {
            try {
                JobProperties responseJobProperties = this.exportDevices(exportBlobContainerUri, excludeKeys);
                future.complete(responseJobProperties);
            }
            catch (IotHubException | IOException | IllegalArgumentException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public JobProperties importDevices(String importBlobContainerUri, String outputBlobContainerUri) throws IllegalArgumentException, IOException, IotHubException, JsonSyntaxException {
        if (importBlobContainerUri == null || outputBlobContainerUri == null) {
            throw new IllegalArgumentException("Import blob uri or output blob uri cannot be null");
        }
        URL url = this.iotHubConnectionString.getUrlCreateExportImportJob();
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        String jobPropertiesJson = this.CreateImportJobPropertiesJson(importBlobContainerUri, outputBlobContainerUri);
        HttpRequest request = this.CreateRequest(url, HttpMethod.POST, jobPropertiesJson.getBytes(), sasTokenString);
        HttpResponse response = request.send();
        return this.ProcessJobResponse(response);
    }

    public CompletableFuture<JobProperties> importDevicesAsync(String importBlobContainerUri, String outputBlobContainerUri) throws IllegalArgumentException, IOException, IotHubException, JsonSyntaxException {
        CompletableFuture<JobProperties> future = new CompletableFuture<JobProperties>();
        this.executor.submit(() -> {
            try {
                JobProperties responseJobProperties = this.importDevices(importBlobContainerUri, outputBlobContainerUri);
                future.complete(responseJobProperties);
            }
            catch (IotHubException | IOException | IllegalArgumentException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public JobProperties getJob(String jobId) throws IllegalArgumentException, IOException, IotHubException, JsonSyntaxException {
        if (jobId == null) {
            throw new IllegalArgumentException("Job id cannot be null");
        }
        URL url = this.iotHubConnectionString.getUrlImportExportJob(jobId);
        String sasTokenString = new IotHubServiceSasToken(this.iotHubConnectionString).toString();
        HttpRequest request = this.CreateRequest(url, HttpMethod.GET, new byte[0], sasTokenString);
        HttpResponse response = request.send();
        return this.ProcessJobResponse(response);
    }

    public CompletableFuture<JobProperties> getJobAsync(String jobId) throws IllegalArgumentException, IOException, IotHubException {
        CompletableFuture<JobProperties> future = new CompletableFuture<JobProperties>();
        this.executor.submit(() -> {
            try {
                JobProperties responseJobProperties = this.getJob(jobId);
                future.complete(responseJobProperties);
            }
            catch (IotHubException | IOException | IllegalArgumentException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private String CreateExportJobPropertiesJson(String exportBlobContainerUri, Boolean excludeKeysInExport) {
        JobProperties jobProperties = new JobProperties();
        jobProperties.setType(JobProperties.JobType.EXPORT);
        jobProperties.setOutputBlobContainerUri(exportBlobContainerUri);
        jobProperties.setExcludeKeysInExport(excludeKeysInExport);
        return jobProperties.toJobPropertiesParser().toJson();
    }

    private String CreateImportJobPropertiesJson(String importBlobContainerUri, String outputBlobContainerUri) {
        JobProperties jobProperties = new JobProperties();
        jobProperties.setType(JobProperties.JobType.IMPORT);
        jobProperties.setInputBlobContainerUri(importBlobContainerUri);
        jobProperties.setOutputBlobContainerUri(outputBlobContainerUri);
        return jobProperties.toJobPropertiesParser().toJson();
    }

    private JobProperties ProcessJobResponse(HttpResponse response) throws IotHubException, JsonSyntaxException {
        IotHubExceptionManager.httpResponseVerification(response);
        String bodyStr = new String(response.getBody(), StandardCharsets.UTF_8);
        JobProperties resultJobProperties = new JobProperties(new JobPropertiesParser(bodyStr));
        return resultJobProperties;
    }

    private HttpRequest CreateRequest(URL url, HttpMethod method, byte[] payload, String sasToken) throws IOException {
        HttpRequest request = new HttpRequest(url, method, payload);
        request.setReadTimeoutMillis(this.DEFAULT_HTTP_TIMEOUT_MS);
        request.setHeaderField("authorization", sasToken);
        request.setHeaderField("Request-Id", "1001");
        request.setHeaderField("Accept", "application/json");
        request.setHeaderField("Content-Type", "application/json");
        request.setHeaderField("charset", "utf-8");
        return request;
    }
}

