/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service;

import com.microsoft.azure.sdk.iot.deps.serializer.RegistryStatisticsParser;

public class RegistryStatistics {
    private long totalDeviceCount;
    private long enabledDeviceCount;
    private long disabledDeviceCount;

    private RegistryStatistics() {
        this.totalDeviceCount = 0L;
        this.enabledDeviceCount = 0L;
        this.disabledDeviceCount = 0L;
    }

    public long getDisabledDeviceCount() {
        return this.disabledDeviceCount;
    }

    public long getEnabledDeviceCount() {
        return this.enabledDeviceCount;
    }

    public long getTotalDeviceCount() {
        return this.totalDeviceCount;
    }

    RegistryStatistics(RegistryStatisticsParser registryStatisticsParser) {
        if (registryStatisticsParser == null) {
            throw new IllegalArgumentException("The registryStatisticsParser may not be null");
        }
        this.totalDeviceCount = registryStatisticsParser.getTotalDeviceCount();
        this.enabledDeviceCount = registryStatisticsParser.getEnabledDeviceCount();
        this.disabledDeviceCount = registryStatisticsParser.getDisabledDeviceCount();
    }

    RegistryStatisticsParser toRegistryStatisticsParser() {
        RegistryStatisticsParser parser = new RegistryStatisticsParser();
        parser.setTotalDeviceCount(this.totalDeviceCount);
        parser.setEnabledDeviceCount(this.enabledDeviceCount);
        parser.setDisabledDeviceCount(this.disabledDeviceCount);
        return parser;
    }
}

